% This function calculates w and the diagonal elements of Sigma for each SV component

function [w,Sigma] = SV_temp(T,N_vola,s_ystar,s_cycle,s_kappa,s_phi1,s_phi2,iota,table_mix)



g=zeros(T,N_vola); w=zeros(T,N_vola); Sigma=zeros(T,N_vola);



g(2:end,1)=s_ystar(2:end,1)-s_ystar(1:end-1,1)-s_kappa(2:end,1); g(1,1)=g(2,1); % trend output level

g(3:end,2)=s_cycle(3:end,1)-s_phi1*s_cycle(2:end-1,1)-s_phi2*s_cycle(1:end-2,1); g(1:2,2)=g(3:4,2); % Cycle

if N_vola==3; g(2:end,3)=s_kappa(2:end,1)-s_kappa(1:end-1,1); g(1,3)=g(2,3); end; % trend output growth

g=log(g.^2+0.001);



for k=1:N_vola

    for t=1:T

        if iota(t,k)==0 % needed?

            Sigma(t,k) = 4.9348;

            w(t,k) = g(t,k) + 1.2704;

        else

            Sigma(t,k) = table_mix(iota(t,k),4);

            w(t,k) = g(t,k) - table_mix(iota(t,k),3) + 1.2704;

        end

    end

end