function [s_p_lambda,s_lambda,s_kappa0,s_kappa,s_sigma_kappa] = Block_kappa(s_ystar,Det,s_kappa_tilde,s_h,a0,A0,c0,C0,p0,j,burn_ur,Model_bin,s_lambda)

w = s_ystar - lagmatrix(s_ystar,1); w=w(2:end);
z=[Det(2:end,:) s_kappa_tilde(2:end)];  Sigma= (exp(s_h(2:end,1))).^2; 

%% Sampling binary indictors
K=size(a0,1)-1;
s_p_lambda=zeros(K,1);
seq = randsample(K,K)'; % randomize the sequence in which the binary indicators are drawn

for k=1:K
    ki=seq(1,k);
    if Model_bin(ki,1)==0                           
        s_p_lambda(ki,1) = 0; s_lambda(ki,1) = 0;
    else      
        if j<burn_ur
            s_p_lambda(ki,1) = 1; s_lambda(ki,1) = 1;
        else
            s_p_lambda(ki,1) = p_bin_calc(w,z,s_lambda,a0,A0,c0,C0,p0,Sigma,1,ki);
            if Model_bin(ki,1)==1
                s_lambda(ki,1) = 1;
            elseif Model_bin(ki,1)==2
                s_lambda(ki,1) = binornd(1,s_p_lambda(ki,1));                                                    
            end
        end
    end
end

%% Sampling variance and parameters conditional on binary indicators
% Restricting matrices according to binary indicators in draw_bin
I0 = find(s_lambda==0);                                                    % construct index indicating which binary indicators are zero
a0r=a0; a0r(1+I0,:)=[];                                                    % imposing restrictions implied by binary indicators
A0r=A0; A0r(:,1+I0)=[]; A0r(1+I0,:)=[];
zr=z; zr(:,1+I0)=[];

% Drawing var_eps from posterior IG and coefs from posterior conditional on var_eps
[~,aT,AT,cT,CT] = Bayesian_regr(w,zr,a0r,A0r,c0,C0,Sigma);                         
if Sigma==0; draw_var = 1./gamrnd(cT,1/CT); else draw_var=1; end;
var_b = AT*draw_var;
draw_tmp = aT + (randn(1,size(aT,1))*chol(var_b))';

% storing results
draw_b = zeros(size(s_lambda,1),1);
draw_b(s_lambda==1,1) = draw_tmp(2:end,1);                                 % storing non-zero stdv values 
draw_b = [draw_tmp(1,1);draw_b];                                           % first element is allways included   

s_kappa0=draw_b(1:end-1,1); s_sigma_kappa=draw_b(end,1);
s_kappa = Det*s_kappa0 + s_sigma_kappa*s_kappa_tilde; 
 
end

