% This function calculates w and the diagonal elements of Sigma for each of the 5 SV components
function [s_h_tilde,s_h,iota] = Block_SV_states(T,s_ystar,s_cycle,s_kappa,s_h,s_phi1,s_phi2,s_h0,s_sigma_gamma,s_theta,table_mix)
K=size(s_h,2);


%% Calculating dependent variable g in linear specifiction
g=zeros(T,2); %w=zeros(T,2); Sigma=zeros(T,2);
g(2:end,1)=s_ystar(2:end,1)-s_ystar(1:end-1,1)-s_kappa(2:end,1); g(1,1)=g(2,1); % trend output level
g(3:end,2)=s_cycle(3:end,1)-s_phi1*s_cycle(2:end-1,1)-s_phi2*s_cycle(1:end-2,1); g(1:2,2)=g(3:4,2); % Cycle
if K==3; g(2:end,3)=s_kappa(2:end,1)-s_kappa(1:end-1,1); g(1,3)=g(2,3); end; % trend output growth
g=log(g.^2+0.001);


%% Drawing s_h_tilde and iota
s_h_tilde=zeros(T,K); iota=zeros(T,K);
for k=1:K   
    % Draw indicators iota (Primiceri: draw BEFORE s_h!!!)
    iota(:,k) = ind_calc2(g(:,k),s_h(:,k),1,table_mix);
    
    if s_theta(k,1)==1
        % State space representation   
        ns = 1;
        Kt = zeros(ns,ns,T); Kt(1,1,:) = ones(1,1,T);
        Zt = ones(1,ns,T)*2*s_sigma_gamma(k,1);  
        Tt = zeros(ns,ns,T); Tt(1,1,:) = ones(1,1,T);
        Qt(1,1)=1; 
    
        Ht = zeros(1,1,T); At = zeros(T,1);
        for t=1:T
            if iota(t,k)==0
                At(t,1) = 2*s_h0(k,1) - 1.2704;
                Ht(1,1,t) = 4.9348;
            else
                At(t,1) = 2*s_h0(k,1) - 1.2704 + table_mix(iota(t,k),3);
                Ht(1,1,t) = table_mix(iota(t,k),4);
            end
        end      
        S0=zeros(ns,1); P0=eye(ns)*0.0001; % initialize state h_tilde at zero
    
        % Kalman filter
        [hStt,hPtt] = Kfilter_um(g(:,k),Zt,At,S0,P0,Qt,Tt,Kt,Ht,[]);
    
        % Sampling states
        [draw] = Ksampler(hStt,hPtt,Qt,Tt,Kt,[]);       

        % Normalization
        s_h_tilde(:,k) = draw;% - mean(draw);
    else
        s_h_tilde(:,k) = cumsum(randn(T,1));
    end
end

%% Reconstructing s_h
s_h = repmat(s_h0',T,1) + s_h_tilde.*repmat(s_sigma_gamma',T,1);      % equal to s_h0 if s_theta=0
