
function [s_p_theta,s_theta,s_h0,s_h,s_sigma_gamma] = Block_SV_para(T,N_vola,s_ystar,s_cycle,s_kappa,s_h_tilde,s_phi1,s_phi2,a0_SV,A0_SV,p0,j,burn_ur,Model_theta,iota,table_mix)


%% Transformations
g=zeros(T,N_vola); w=zeros(T,N_vola); Sigma=zeros(T,N_vola);

g(2:end,1)=s_ystar(2:end,1)-s_ystar(1:end-1,1)-s_kappa(2:end,1); g(1,1)=g(2,1); % trend output level
g(3:end,2)=s_cycle(3:end,1)-s_phi1*s_cycle(2:end-1,1)-s_phi2*s_cycle(1:end-2,1); g(1:2,2)=g(3:4,2); % Cycle
if N_vola==3; g(2:end,3)=s_kappa(2:end,1)-s_kappa(1:end-1,1); g(1,3)=g(2,3); end; % trend output growth
g=log(g.^2+0.001);

for k=1:N_vola
    for t=1:T
        if iota(t,k)==0
            Sigma(t,k) = 4.9348;
            w(t,k) = g(t,k) + 1.2704;
        else
            Sigma(t,k) = table_mix(iota(t,k),4);
            w(t,k) = g(t,k) - table_mix(iota(t,k),3) + 1.2704;
        end
    end
end

%% binary indicators (s_theta) and parameters (h0,stdv_gamma)
s_p_theta=zeros(N_vola,1);s_theta=zeros(N_vola,1);s_h0=zeros(N_vola,1);s_sigma_gamma=zeros(N_vola,1);
for k=1:N_vola
    z = 2*[ones(T,1) s_h_tilde(:,k)]; 
    [s_p_theta(k,1),s_theta(k,1),draw_b]=Block1(g(:,k),z,a0_SV(:,:,k),A0_SV(:,:,k),[],[],p0,j,burn_ur,Model_theta(k,1),Sigma(:,k));
    s_h0(k,1)=draw_b(1,1); s_sigma_gamma(k,1)=draw_b(1,2);  
end
s_h = repmat(s_h0',T,1) + s_h_tilde.*repmat(s_sigma_gamma',T,1);

end