clear
clear matrix
capture log close
set more 1
set mem 1000m
set matsize 800
global datadir "C:\Users\WB388526\OneDrive - WBG\REVISION\nreg2"
cd "C:\Users\WB388526\OneDrive - WBG\REVISION\replication"



************************************************************************************************************
use DATAlong, clear
	* ADD. 2.
	xi: probit INDwatchedR2 ageR1 age_2R1 i.educR1 i.relheadR1 i.marital_stR1 gender ///
		 male_pearlR1 female_pearlR1  lhhsizeR1 lhhsize_2R1 madult_shR1 ///
		 fadult_shR1 old_shR1 kidsy_shR1 sexhhhR1 agehhhR1 agehhh_2R1 ///
		 i.maxeduR1 caste_scR1 caste_maha*R1 caste_obcR1 caste_stR1 ///
		 rel_hinduR1 assethouseR1  assethouse_2R1 assethouse_3R1 totlandR1 ///
		 totland_2R1 card_bplR1 close_mukhiyaR1 close_wardR1 close_bdoR1 ///
		 close_politR1 pol_voteR1 shock_*R1 somecas_mR1 somecas_fR1 ///
		 nomig_mR1 mainother_b2_regR1 gpbhawanR1 mukhiya_ageR1 mukhiya_invillR1 ///
		 mukhiya_maleR1  mukhiya_primR1  mukhiya_selfagR1 mukhiya_exp1R1 ///
		 mukhiya_exp2R1  mukhiya_contractorR1  l_prscR1 l_probcR1 vhinduR1 ///
		 velecR1 vproadR1 vdis_busR1 vdis_gpR1 vdis_townR1 vdis_blockR1 ///
		 vfac_postR1 vfac_nonagR1 lvasset_mR1 vasset_ineqR1 l_prkuchchaR1 ///
		 l_prbplR1 vshk_floodR1 vshk_droughtR1 vshockR1 vgoodsocgrpR1 ///
		 WOMEN_GRPR1 NGO_GRPR1 NREG_GRPR1 OTHER_GRPR1 if PANELIND==1 & movie==1 [pw=hhwtR2], robust

predict p

sum p if movie==1
drop if p<r(min) & movie==0
sum p if movie==0
drop if p>r(max) & movie==1

* figure 1:
set scheme s2mono
twoway(kdensity p if movie==1)(kdensity p if movie==0, ///
	xtitle("predicted P(mij=1|Xijv)") ytitle("density of the propensity score") ///
	legend(label(1 "Movie village=1") label(2 "Movie village=0")) plotregion(style(none))  graphregion(fcolor(white)))

* ADD. 3.a.; COLUMN PSM:
foreach T in 0 1{
	foreach K in aw_emp_index aw_fac_index{
			teffects  nnmatch (`K'R2 p) (movie) if movie==0 | INDwatchedR2==`T', atet nn(1)
			if `T'==0{
				quiet: psmatch2  movie if movie==0 | INDwatchedR2==`T', outcome(`K'R2) pscore(p) neighbor(1)
				tabstat _`K'R2, stat(mean semean N)
				}
			teffects  nnmatch (`K'R2 p) (movie) if TWOPANELIND==1 & (movie==0 | INDwatchedR2==`T'), atet nn(1)
		}
}
* TABLE 6 AND 7; COLUMN PSM:
keep if TWOPANELIND
foreach T in 0 1{
	foreach K in aw_emp_index aw_fac_index{
			teffects  nnmatch (`K'R2 p) (movie) if movie==0 | INDwatchedR2==`T', atet nn(1)
			if `T'==0{
				quiet: psmatch2  movie if movie==0 | INDwatchedR2==`T', outcome(`K'R2) pscore(p) neighbor(1)
				tabstat _`K'R2, stat(mean semean N)
				}
			teffects  nnmatch (`K'R2 p) (movie) if TWOPANELIND==1 & (movie==0 | INDwatchedR2==`T'), atet nn(1)
		}
}
************************************************************************************************************
* ADD. 3.a.; COLUMNS Nave OLS_with_controls IV ITT:
use DATAlong, clear
keep if PANELIND
foreach K in aw_emp_index aw_fac_index{
	* ITT:
		quiet: reg `K'R2 		movie	[aw=hhwtR2], vce(robust)
		est store A2
	* NAIVE ESTIMATE:
		quiet: reg `K'R2 		movie	INDwatchedmovieR2 [aw=hhwtR2], vce(robust)
		est store B2
		lincom movie+INDwatchedmovieR2	
	* IV estimate
		label var INDwatchedmovieR2 "beta"
		quiet: ivreg `K'R2 (INDwatchedmovieR2=movie) [aw=hhwtR2], robust first 
		est store B3
	* WITH CONTROL:
		quiet: xi: reg `K'R2 movie	INDwatchedmovieR2 ///
		ageR1 age_2R1 i.educR1 i.relheadR1 i.marital_stR1 gender male_pearlR1 female_pearlR1  lhhsizeR1 lhhsize_2R1 madult_shR1 ///
		fadult_shR1 old_shR1 kidsy_shR1 sexhhhR1 agehhhR1 agehhh_2R1 i.maxeduR1 caste_scR1 caste_maha*R1 caste_obcR1 caste_stR1 rel_hinduR1 assethouseR1  ///
		assethouse_2R1 assethouse_3R1 totlandR1 totland_2R1 card_bplR1 close_mukhiyaR1 close_wardR1 close_bdoR1 close_politR1 pol_voteR1 shock_*R1 somecas_mR1 ///
		somecas_fR1 nomig_mR1 mainother_b2_regR1 gpbhawanR1 mukhiya_ageR1 mukhiya_invillR1 mukhiya_maleR1  mukhiya_primR1  mukhiya_selfagR1 mukhiya_exp1R1 ///
		mukhiya_exp2R1  mukhiya_contractorR1  l_prscR1 l_probcR1 vhinduR1 velecR1 vproadR1 vdis_busR1 vdis_gpR1 vdis_townR1 vdis_blockR1  vfac_postR1 vfac_nonagR1 ///
		lvasset_mR1 vasset_ineqR1 l_prkuchchaR1 l_prbplR1 vshk_floodR1 vshk_droughtR1 vshockR1 vgoodsocgrpR1 WOMEN_GRPR1 NGO_GRPR1 NREG_GRPR1 OTHER_GRPR1 ///
		[aw=hhwtR2], robust
		est store B4
		lincom movie+INDwatchedmovieR2
	* EXPORT:
		esttab B2 B4 B3 A2, replace b(%12.2f) se(%12.2f) star(* 0.10 ** 0.05 *** 0.01) ///
		not	mtitle("OLS" "OLS WITH CONTROLS" "IV" "ITT" ) label ///
		keep(movie INDwatchedmovieR2 _cons)
}
************************************************************************************************************
* TABLE 5: TEST OF THE PARALLEL TRENDS ASSUMPTION 
use DATAlong, clear
keep if PANELIND
		quiet: xi: probit INDwatchedR2 ageR1 age_2R1 i.educR1 i.relheadR1 i.marital_stR1 gender ///
				 male_pearlR1 female_pearlR1  lhhsizeR1 lhhsize_2R1 madult_shR1 ///
				 fadult_shR1 old_shR1 kidsy_shR1 sexhhhR1 agehhhR1 agehhh_2R1 ///
				 i.maxeduR1 caste_scR1 caste_maha*R1 caste_obcR1 caste_stR1 ///
				 rel_hinduR1 assethouseR1  assethouse_2R1 assethouse_3R1 totlandR1 ///
				 totland_2R1 card_bplR1 close_mukhiyaR1 close_wardR1 close_bdoR1 ///
				 close_politR1 pol_voteR1 shock_*R1 somecas_mR1 somecas_fR1 ///
				 nomig_mR1 mainother_b2_regR1 gpbhawanR1 mukhiya_ageR1 mukhiya_invillR1 ///
				 mukhiya_maleR1  mukhiya_primR1  mukhiya_selfagR1 mukhiya_exp1R1 ///
				 mukhiya_exp2R1  mukhiya_contractorR1  l_prscR1 l_probcR1 vhinduR1 ///
				 velecR1 vproadR1 vdis_busR1 vdis_gpR1 vdis_townR1 vdis_blockR1 ///
				 vfac_postR1 vfac_nonagR1 lvasset_mR1 vasset_ineqR1 l_prkuchchaR1 ///
				 l_prbplR1 vshk_floodR1 vshk_droughtR1 vshockR1 vgoodsocgrpR1 ///
				 WOMEN_GRPR1 NGO_GRPR1 NREG_GRPR1 OTHER_GRPR1 if TWOPANELIND==1 & movie==1 [pw=hhwtR2], robust
		predict p

save temp, replace
set more off
foreach K in aw_emp_index aw_fac_index{
		use temp, clear
		keep if TWOPANELIND
			keep INDwatchedmovieR2 `K'R2 `K'R1 individual p hhid movie hhwtR2
			reshape wide INDwatchedmovieR2 `K'R2 `K'R1 p, i(hhid) j(individual) string
		gen diffm	=	INDwatchedmovieR2I2	-	INDwatchedmovieR2I1
		gen diffk	=	(`K'R2I2	-	`K'R1I2) - (`K'R2I1	-	`K'R1I1)
		gen diffres	=	pI2 - pI1
		label var diffm "beta"
		reg diffk  diffm diffres [aw=hhwtR2], nocons vce(robust)	
		esttab using exo_test`K'.csv, replace b(%12.2f) se(%12.2f) star(* 0.10 ** 0.05 *** 0.01) not csv
}
foreach K in   aw_emp_index aw_fac_index{
use temp, clear
keep if TWOPANELIND
			keep `K'* hhcatR1 hhwtR2 hhid individual INDwatchedmovie* CASTER* landlessR* poorR* both_illiterateR* politR* p
			reshape wide `K'* INDwatchedmovie* p, i(hhid) j(individual) string
			gen diffm	=	INDwatchedmovieR2I2	-	INDwatchedmovieR2I1
			gen diffk	=	(`K'R2I2	-	`K'R1I2) - (`K'R2I1	-	`K'R1I1)
			gen diffres	=	pI2 - pI1			
			label var diffm "beta"
			reg diffk  diffm   	diffres		[aw=hhwtR2], nocons vce(robust)
				* NREGS STATUS ROUND 1:
				di "------------------NREGS STATUS------------------"
				foreach l in 1 2 3{
				reg diffk  diffm diffres if hhcatR1==`l'	[aw=hhwtR2], nocons vce(robust)
				}
				* CASTE ROUND 1:
				di "------------------CASTE------------------"
				foreach l in 1 2{
				reg diffk  diffm diffres if CASTER1==`l'	[aw=hhwtR2], nocons vce(robust)
				}
				* LANDLESS ROUND 1:
				di "------------------LANDLESS------------------"
				foreach l in 0 1{
				reg diffk  diffm diffres if landlessR1==`l'	[aw=hhwtR2], nocons vce(robust)
				}
				* POOR ROUND 1:
				di "------------------POOR------------------"
				foreach l in 0 1{
				reg diffk  diffm diffres if poorR1==`l'	[aw=hhwtR2], nocons vce(robust)
				}	
				* BOTH ILLITERATE ROUND 1:
				di "------------------ILLITERATE------------------"
				foreach l in 0 1{
				reg diffk  diffm diffres if both_illiterateR1==`l'	[aw=hhwtR2], nocons vce(robust)
				}
				
}
************************************************************************************************************
* TABLES 6 and 8:
foreach K in aw_emp_index aw_fac_index{
		use DATAlong, clear
		keep if TWOPANELIND
					keep INDwatchedmovieR2 `K'R2 `K'R1 individual hhid movie hhwtR2
			reshape wide INDwatchedmovieR2 `K'R2 `K'R1, i(hhid) j(individual) string

		gen diffm	=	INDwatchedmovieR2I2	-	INDwatchedmovieR2I1
		di "blo"
		gen diffk	=	(`K'R2I2	-	`K'R1I2) - (`K'R2I1	-	`K'R1I1)
		label var diffm "beta"
		count
		sum diffk  diffm
		reg diffk  diffm   			[aw=hhwtR2], nocons vce(robust)
		est store B1
		local beta=_b[diffm]
	* identify HH where diffm is missing because one of the individuals has missing movie info:
	duplicates drop hhid, force
	keep hhid diffm
	save temp1, replace
		
		use DATAlong, clear
		keep if TWOPANELIND
		* keep only HH where we do have non-missing diffm
		merge m:1 hhid using temp1
		drop if diffm==.
		label var movie "alpha1-alpha0"
		
		gen LHS			=`K'R2-`beta'	*INDwatchedmovieR2
		label var LHS "beta"
		
		reg LHS 	movie					[aw=hhwtR2], vce(robust)
		est store A1

		quiet: reg `K'R2 		movie	[aw=hhwtR2], vce(robust)
		est store A2

		* OLS:

		quiet: reg `K'R2 		movie	INDwatchedmovieR2 [aw=hhwtR2], vce(robust)
		est store B2
		lincom movie+INDwatchedmovieR2

		
		* IV estimate
		label var INDwatchedmovieR2 "beta"
		quiet: ivreg `K'R2 (INDwatchedmovieR2=movie) [aw=hhwtR2], robust first 
		est store B3


		* OLS with controls:
		quiet: xi: reg `K'R2 movie	INDwatchedmovieR2 ///
		ageR1 age_2R1 i.educR1 i.relheadR1 i.marital_stR1 gender male_pearlR1 female_pearlR1  lhhsizeR1 lhhsize_2R1 madult_shR1 ///
		fadult_shR1 old_shR1 kidsy_shR1 sexhhhR1 agehhhR1 agehhh_2R1 i.maxeduR1 caste_scR1 caste_maha*R1 caste_obcR1 caste_stR1 rel_hinduR1 assethouseR1  ///
		assethouse_2R1 assethouse_3R1 totlandR1 totland_2R1 card_bplR1 close_mukhiyaR1 close_wardR1 close_bdoR1 close_politR1 pol_voteR1 shock_*R1 somecas_mR1 ///
		somecas_fR1 nomig_mR1 mainother_b2_regR1 gpbhawanR1 mukhiya_ageR1 mukhiya_invillR1 mukhiya_maleR1  mukhiya_primR1  mukhiya_selfagR1 mukhiya_exp1R1 ///
		mukhiya_exp2R1  mukhiya_contractorR1  l_prscR1 l_probcR1 vhinduR1 velecR1 vproadR1 vdis_busR1 vdis_gpR1 vdis_townR1 vdis_blockR1  vfac_postR1 vfac_nonagR1 ///
		lvasset_mR1 vasset_ineqR1 l_prkuchchaR1 l_prbplR1 vshk_floodR1 vshk_droughtR1 vshockR1 vgoodsocgrpR1 WOMEN_GRPR1 NGO_GRPR1 NREG_GRPR1 OTHER_GRPR1 ///
		[aw=hhwtR2], robust
		est store B4
		lincom movie+INDwatchedmovieR2
		
		esttab B1 A1  B2 B4	B3 A2, replace b(%12.2f) se(%12.2f) star(* 0.10 ** 0.05 *** 0.01) ///
		not csv		mtitle("MAIN 1st" "MAIN 2nd" "OLS" "OLS WITH CONTROLS" "IV" "ITT" ) label ///
		keep(movie diffm INDwatchedmovieR2 _cons)
}
************************************************************************************************************
* TABLES 7 and 9; ESTIMATES
foreach K in   aw_emp_index aw_fac_index{
use DATAlong, clear
keep if TWOPANELIND

	merge m:1 hhid using temp1
	drop if diffm==.

			keep `K'* hhcatR1 hhwtR2 hhid individual INDwatchedmovie* CASTER* landlessR* poorR* both_illiterateR* politR*
			reshape wide `K'* INDwatchedmovie*, i(hhid) j(individual) string
			gen diffm	=	INDwatchedmovieR2I2	-	INDwatchedmovieR2I1
			gen diffk	=	(`K'R2I2	-	`K'R1I2) - (`K'R2I1	-	`K'R1I1)
			
			label var diffm "beta"
			
			reg diffk  diffm   			[aw=hhwtR2], nocons vce(robust)

			local beta			=_b[diffm]
			
				* NREGS STATUS ROUND 1:
				foreach l in 1 2 3{
				reg diffk  diffm if hhcatR1==`l'	[aw=hhwtR2], nocons vce(robust)
				local beta`l'			=_b[diffm]
				}
				* CASTE ROUND 1:
				foreach l in 1 2{
				reg diffk  diffm if CASTER1==`l'	[aw=hhwtR2], nocons vce(robust)
				local betacaste`l'			=_b[diffm]
				}
				* LANDLESS ROUND 1:
				foreach l in 0 1{
				reg diffk  diffm if landlessR1==`l'	[aw=hhwtR2], nocons vce(robust)
				local betalandless`l'			=_b[diffm]
				}
				* POOR ROUND 1:
				foreach l in 0 1{
				reg diffk  diffm if poorR1==`l'	[aw=hhwtR2], nocons vce(robust)
				local betapoor`l'			=_b[diffm]
				}	
				* BOTH ILLITERATE ROUND 1:
				foreach l in 0 1{
				reg diffk  diffm if both_illiterateR1==`l'	[aw=hhwtR2], nocons vce(robust)
				local betailliterate`l'			=_b[diffm]
				}
				
				* POLITICAL CONNECTION (WARD OR MUKH.) ROUND 1:
				foreach l in 0 1{
				reg diffk  diffm if politR1==`l'	[aw=hhwtR2], nocons vce(robust)
				local betaPOLIT`l'			=_b[diffm]
				}

			use DATAlong, clear
			    keep if TWOPANELIND
				* keep only HH where we do have non-missing diffm
				merge m:1 hhid using temp1
				drop if diffm==.

			label var movie "alpha1-alpha0"
			
			preserve
			gen LHS			=`K'R2-`beta'	*INDwatchedmovieR2
			reg LHS 	movie				[aw=hhwtR2], vce(robust)

				
				* GENDER:
				reg LHS 	movie			if individual=="I1"		[aw=hhwtR2], vce(robust)
				reg LHS 	movie			if individual=="I2"		[aw=hhwtR2], vce(robust)
				
			restore
			
			
			preserve
				* NREGS STATUS ROUND 1:
				foreach l in 1 2 3{
				gen LHS`l'			=`K'R2-`beta`l''	*INDwatchedmovieR2
				reg LHS`l' 	movie	if hhcatR1==`l'	[aw=hhwtR2], vce(robust)
				}
			restore
			preserve
				* CASTE ROUND 1:
				foreach l in 1 2{
				gen LHS`l'			=`K'R2-`betacaste`l''	*INDwatchedmovieR2
				reg LHS`l' 	movie	if CASTER1==`l'	[aw=hhwtR2], vce(robust)
			}
		restore
		preserve
			* LANDLESS ROUND 1:
			foreach l in 0 1{
			gen LHS`l'			=`K'R2-`betalandless`l''	*INDwatchedmovieR2
			reg LHS`l' 	movie	if landlessR1==`l'	[aw=hhwtR2], vce(robust)
			}
		restore
		preserve
			* POOR ROUND 1:
			foreach l in 0 1{
			gen LHS`l'			=`K'R2-`betapoor`l''	*INDwatchedmovieR2
			reg LHS`l' 	movie	if poorR1==`l'	[aw=hhwtR2], vce(robust)
			}
		restore
		preserve
			* NB OF ILLITERATE ROUND 1:
			foreach l in 0 1{
			gen LHS`l'			=`K'R2-`betailliterate`l''	*INDwatchedmovieR2
			reg LHS`l' 	movie	if both_illiterateR1==`l'	[aw=hhwtR2], vce(robust)
			}
		restore
		
		preserve
			* POLITICAL CONNECTION (WARD OR MUKH.) ROUND 1:
			foreach l in 0 1{
			gen LHS`l'			=`K'R2-`betaPOLIT`l''	*INDwatchedmovieR2
			reg LHS`l' 	movie	if politR1==`l'	[aw=hhwtR2], vce(robust)
			}
		restore
}
* BOOTSTRAPPING S.E.
set more off
		capture program drop myboo
			program define myboo, rclass
			version 13.1
				local K `1'				
				preserve
				keep `K'* hhcatR1 hhwtR2 newhhid individual INDwatchedmovie* CASTER* landlessR* poorR* both_illiterateR* politR*
				reshape wide `K'* INDwatchedmovie*, i(newhhid) j(individual) string
				gen diffm	=	INDwatchedmovieR2I2	-	INDwatchedmovieR2I1
				gen diffk	=	(`K'R2I2	-	`K'R1I2) - (`K'R2I1	-	`K'R1I1)
				reg diffk  diffm   			[aw=hhwtR2], nocons vce(robust)
				local beta			=_b[diffm]			
					* NREGS STATUS ROUND 1:
					foreach l in 1 2 3{
					reg diffk  diffm if hhcatR1==`l'	[aw=hhwtR2], nocons vce(robust)
					local beta`l'			=_b[diffm]
					}
					* CASTE ROUND 1:
					foreach l in 1 2{
					reg diffk  diffm if CASTER1==`l'	[aw=hhwtR2], nocons vce(robust)
					local betacaste`l'			=_b[diffm]
					}
					* LANDLESS ROUND 1:
					foreach l in 0 1{
					reg diffk  diffm if landlessR1==`l'	[aw=hhwtR2], nocons vce(robust)
					local betalandless`l'			=_b[diffm]
					}
					* POOR ROUND 1:
					foreach l in 0 1{
					reg diffk  diffm if poorR1==`l'	[aw=hhwtR2], nocons vce(robust)
					local betapoor`l'			=_b[diffm]
					}	
					* BOTH ILLITERATE ROUND 1:
					foreach l in 0 1{
					reg diffk  diffm if both_illiterateR1==`l'	[aw=hhwtR2], nocons vce(robust)
					local betailliterate`l'			=_b[diffm]
					}
					* POLITICAL CONNECTION (WARD OR MUKH.) ROUND 1:
					foreach l in 0 1{
					reg diffk  diffm if politR1==`l'	[aw=hhwtR2], nocons vce(robust)
					local betaPOLIT`l'			=_b[diffm]
					}
				restore				

				preserve
				gen LHS			=`K'R2-`beta'	*INDwatchedmovieR2
				reg LHS 	movie				[aw=hhwtR2], vce(robust)
				return scalar ATE	=_b[movie]	+`beta'
				return scalar gamma	=1-_b[movie]/(_b[movie]	+`beta')
					* GENDER HETEROGENEITY:
						reg LHS 	movie	if gender==1	[aw=hhwtR2], vce(robust)
						return scalar ATEmale	=_b[movie]	+`beta'
						return scalar gammamale	=1-_b[movie]/(_b[movie]	+`beta')
						reg LHS 	movie	if gender==0	[aw=hhwtR2], vce(robust)
						return scalar ATEfemale	=_b[movie]	+`beta'
						return scalar gammafemale	=1-_b[movie]/(_b[movie]	+`beta')		
				restore
				preserve
					* NREGS STATUS ROUND 1:
					foreach l in 1 2 3{
					gen LHS`l'			=`K'R2-`beta`l''	*INDwatchedmovieR2
					reg LHS`l' 	movie	if hhcatR1==`l'	[aw=hhwtR2], vce(robust)
					return scalar ATE`l'	=_b[movie]	+`beta`l''
					return scalar gamma`l'	=1-_b[movie]/(_b[movie]	+`beta`l'')
					}
				restore
				preserve
					* CASTE ROUND 1:
					foreach l in 1 2{
					gen LHS`l'			=`K'R2-`betacaste`l''	*INDwatchedmovieR2
					reg LHS`l' 	movie	if CASTER1==`l'	[aw=hhwtR2], vce(robust)
					return scalar ATEcaste`l'	=_b[movie]	+`betacaste`l''
					return scalar gammacaste`l'	=1-_b[movie]/(_b[movie]	+`betacaste`l'')
					}
				restore
				preserve
					* LANDLESS ROUND 1:
					foreach l in 0 1{
					gen LHS`l'			=`K'R2-`betalandless`l''	*INDwatchedmovieR2
					reg LHS`l' 	movie	if landlessR1==`l'	[aw=hhwtR2], vce(robust)
					return scalar ATElandless`l'	=_b[movie]	+`betalandless`l''
					return scalar gammalandless`l'	=1-_b[movie]/(_b[movie]	+`betalandless`l'')
					}
				restore
				preserve
					* POOR ROUND 1:
					foreach l in 0 1{
					gen LHS`l'			=`K'R2-`betapoor`l''	*INDwatchedmovieR2
					reg LHS`l' 	movie	if poorR1==`l'	[aw=hhwtR2], vce(robust)
					return scalar ATEpoor`l'	=_b[movie]	+`betapoor`l''
					return scalar gammapoor`l'	=1-_b[movie]/(_b[movie]	+`betapoor`l'')
					}
				restore
				preserve
					* NB OF ILLITERATE ROUND 1:
					foreach l in 0 1{
					gen LHS`l'			=`K'R2-`betailliterate`l''	*INDwatchedmovieR2
					reg LHS`l' 	movie	if both_illiterateR1==`l'	[aw=hhwtR2], vce(robust)
					return scalar ATEilliterate`l'	=_b[movie]	+`betailliterate`l''
					return scalar gammailliterate`l'	=1-_b[movie]/(_b[movie]	+`betailliterate`l'')
					}
				restore
				preserve
					* POLITICAL CONNECTION (WARD OR MUKH.) ROUND 1:
					foreach l in 0 1{
					gen LHS`l'			=`K'R2-`betaPOLIT`l''	*INDwatchedmovieR2
					reg LHS`l' 	movie	if politR1==`l'	[aw=hhwtR2], vce(robust)
					return scalar ATEPOLIT`l'	=_b[movie]	+`betaPOLIT`l''
					return scalar gammaPOLIT`l'	=1-_b[movie]/(_b[movie]	+`betaPOLIT`l'')
					}
				restore
			end	
* TABLES 6, 7, 8 and 9; BOOTSTRAPPED S.E.		
foreach K in aw_fac_index   aw_emp_index {	
	use DATAlong, clear
	keep if TWOPANELIND
	* keep only HH where we do have non-missing diffm
		merge m:1 hhid using temp1
		drop if diffm==.
	bootstrap ///
		ATE=r(ATE) ATE1=r(ATE1) ATE2=r(ATE2) ATE3=r(ATE3) ///
		gamma=r(gamma) gamma1=r(gamma1) gamma2=r(gamma2) gamma3=r(gamma3) ///
			ATEcaste1=r(ATEcaste1) 			ATEcaste2=r(ATEcaste2)  ///
			gammacaste1=r(gammacaste1) 		gammacaste2=r(gammacaste2)  ///
		ATEpoor1=r(ATEpoor1) 			ATEpoor0=r(ATEpoor0)  ///
		gammapoor1=r(gammapoor1) 		gammapoor0=r(gammapoor0)  ///
			ATElandless1=r(ATElandless1) 		ATElandless0=r(ATElandless0)  ///
			gammalandless1=r(gammalandless1) 	gammalandless0=r(gammalandless0)  ///
		ATEilliterate1=r(ATEilliterate1) 			ATEilliterate0=r(ATEilliterate0) ///
		gammailliterate1=r(gammailliterate1) 	gammailliterate0=r(gammailliterate0) ///
			ATEmale=r(ATEmale) 					ATEfemale=r(ATEfemale) ///
			gammamale=r(gammamale) 				gammafemale=r(gammafemale) ///
		ATEPOLIT1=r(ATEPOLIT1) 				ATEPOLIT0=r(ATEPOLIT0) ///
		gammaPOLIT1=r(gammaPOLIT1) 			gammaPOLIT0=r(gammaPOLIT0) ///
	, rep(5) cluster(hhid) idcluster(newhhid) saving(ATE`K', replace) seed(1234): myboo `K'	
	foreach phi in gamma gamma1 gamma2 gamma3 ///
				gammacaste1 gammacaste2 ///
				gammapoor0 gammapoor1 ///
				gammalandless0 gammalandless1 ///
				gammailliterate1 gammailliterate0 ///
				gammamale 	gammafemale ///
				gammaPOLIT1 gammaPOLIT0 {			
	test _b[`phi']=0
	}
	esttab using ATE`K'.csv, replace b(%12.2f) se(%12.2f) not csv label star(* 0.10 ** 0.05 *** 0.01)  ///
		keep(	ATE ATE1 ATE2 ATE3 ///
				ATEcaste1 ATEcaste2 ///
				ATEpoor0 ATEpoor1 ///
				ATElandless0 ATElandless1 ///
				ATEilliterate1 ATEilliterate0 ///
				ATEmale 	ATEfemale ///
				ATEPOLIT1 ATEPOLIT0 ///
				gamma gamma1 gamma2 gamma3 ///
				gammacaste1 gammacaste2 ///
				gammapoor0 gammapoor1 ///
				gammalandless0 gammalandless1 ///
				gammailliterate1 gammailliterate0 ///
				gammamale 	gammafemale ///
				gammaPOLIT1 gammaPOLIT0)
	}		
************************************************************************************************************
* ADD. 3.b.; estimates
foreach K in aw_emp_index aw_fac_index{
* DEFINE CONSISTANT SAMPLE TO USE ACROSS METHODS:
		* SAMPLE VALID FOR OLS W/CONTROLS:
		use DATAlong, clear
		keep if TWOPANELIND
			quiet: xi: reg `K'R2 movie	INDwatchedmovieR2 ///
			ageR1 age_2R1 i.educR1 i.relheadR1 i.marital_stR1 gender male_pearlR1 female_pearlR1  lhhsizeR1 lhhsize_2R1 madult_shR1 ///
			fadult_shR1 old_shR1 kidsy_shR1 sexhhhR1 agehhhR1 agehhh_2R1 i.maxeduR1 caste_scR1 caste_maha*R1 caste_obcR1 caste_stR1 rel_hinduR1 assethouseR1  ///
			assethouse_2R1 assethouse_3R1 totlandR1 totland_2R1 card_bplR1 close_mukhiyaR1 close_wardR1 close_bdoR1 close_politR1 pol_voteR1 shock_*R1 somecas_mR1 ///
			somecas_fR1 nomig_mR1 mainother_b2_regR1 gpbhawanR1 mukhiya_ageR1 mukhiya_invillR1 mukhiya_maleR1  mukhiya_primR1  mukhiya_selfagR1 mukhiya_exp1R1 ///
			mukhiya_exp2R1  mukhiya_contractorR1  l_prscR1 l_probcR1 vhinduR1 velecR1 vproadR1 vdis_busR1 vdis_gpR1 vdis_townR1 vdis_blockR1  vfac_postR1 vfac_nonagR1 ///
			lvasset_mR1 vasset_ineqR1 l_prkuchchaR1 l_prbplR1 vshk_floodR1 vshk_droughtR1 vshockR1 vgoodsocgrpR1 WOMEN_GRPR1 NGO_GRPR1 NREG_GRPR1 OTHER_GRPR1 ///
			[aw=hhwtR2], robust		
		keep if e(sample)
		save temp_consistant, replace		
			* SAMPLE VALID FOR PREFERED METHOD:
			keep INDwatchedmovieR2 `K'R2 `K'R1 individual hhid movie hhwtR2
			reshape wide INDwatchedmovieR2 `K'R2 `K'R1, i(hhid) j(individual) string
			gen diffm	=	INDwatchedmovieR2I2	-	INDwatchedmovieR2I1
			duplicates drop hhid, force
			keep hhid diffm
			merge 1:m hhid using temp_consistant, nogen
			drop if diffm==.
		save temp_consistant, replace		


		use temp_consistant, clear
		keep if TWOPANELIND
		
			keep INDwatchedmovieR2 `K'R2 `K'R1 individual hhid movie hhwtR2
			reshape wide INDwatchedmovieR2 `K'R2 `K'R1, i(hhid) j(individual) string

		gen diffm	=	INDwatchedmovieR2I2	-	INDwatchedmovieR2I1
		di "blo"
		gen diffk	=	(`K'R2I2	-	`K'R1I2) - (`K'R2I1	-	`K'R1I1)



		label var diffm "beta"
		count
		sum diffk  diffm
		reg diffk  diffm   			[aw=hhwtR2], nocons vce(robust)
		est store B1
		local beta=_b[diffm]
		

		use temp_consistant, clear
		keep if TWOPANELIND

		label var movie "alpha1-alpha0"
		
		gen LHS			=`K'R2-`beta'	*INDwatchedmovieR2
		label var LHS "beta"
		
		reg LHS 	movie					[aw=hhwtR2], vce(robust)
		est store A1

		quiet: reg `K'R2 		movie	[aw=hhwtR2], vce(robust)
		est store A2

		* OLS estimate:

		quiet: reg `K'R2 		movie	INDwatchedmovieR2 [aw=hhwtR2], vce(robust)
		est store B2
		lincom movie+INDwatchedmovieR2

		
		* IV estimate
		label var INDwatchedmovieR2 "beta"
		quiet: ivreg `K'R2 (INDwatchedmovieR2=movie) [aw=hhwtR2], robust first 
		est store B3


		* OLS estimate with controls:
		quiet: xi: reg `K'R2 movie	INDwatchedmovieR2 ///
		ageR1 age_2R1 i.educR1 i.relheadR1 i.marital_stR1 gender male_pearlR1 female_pearlR1  lhhsizeR1 lhhsize_2R1 madult_shR1 ///
		fadult_shR1 old_shR1 kidsy_shR1 sexhhhR1 agehhhR1 agehhh_2R1 i.maxeduR1 caste_scR1 caste_maha*R1 caste_obcR1 caste_stR1 rel_hinduR1 assethouseR1  ///
		assethouse_2R1 assethouse_3R1 totlandR1 totland_2R1 card_bplR1 close_mukhiyaR1 close_wardR1 close_bdoR1 close_politR1 pol_voteR1 shock_*R1 somecas_mR1 ///
		somecas_fR1 nomig_mR1 mainother_b2_regR1 gpbhawanR1 mukhiya_ageR1 mukhiya_invillR1 mukhiya_maleR1  mukhiya_primR1  mukhiya_selfagR1 mukhiya_exp1R1 ///
		mukhiya_exp2R1  mukhiya_contractorR1  l_prscR1 l_probcR1 vhinduR1 velecR1 vproadR1 vdis_busR1 vdis_gpR1 vdis_townR1 vdis_blockR1  vfac_postR1 vfac_nonagR1 ///
		lvasset_mR1 vasset_ineqR1 l_prkuchchaR1 l_prbplR1 vshk_floodR1 vshk_droughtR1 vshockR1 vgoodsocgrpR1 WOMEN_GRPR1 NGO_GRPR1 NREG_GRPR1 OTHER_GRPR1 ///
		[aw=hhwtR2], robust
		est store B4
		lincom movie+INDwatchedmovieR2
		
		esttab B1 A1  B2 B4	B3 A2, replace b(%12.2f) se(%12.2f) star(* 0.10 ** 0.05 *** 0.01) ///
		not csv		mtitle("MAIN 1st" "MAIN 2nd" "NAIVE EST" "WITH CONTROLS" "IV" "ITT" ) label ///
		keep(movie diffm INDwatchedmovieR2 _cons)

}
* ADD. 3b. BOOTSTRAPPED S.E.
set more off		
	foreach K in aw_fac_index   aw_emp_index {	
	use temp_consistant, clear
	keep if TWOPANELIND
	* keep only HH where we do have non-missing diffm
	bootstrap ///
		ATE=r(ATE) ATE1=r(ATE1) ATE2=r(ATE2) ATE3=r(ATE3) ///
		gamma=r(gamma) gamma1=r(gamma1) gamma2=r(gamma2) gamma3=r(gamma3) ///
	, rep(5) cluster(hhid) idcluster(newhhid) saving(ATE`K', replace) seed(1234): myboo `K'	
	foreach phi in gamma gamma1 gamma2 gamma3 {			
		test _b[`phi']=0
	}
	esttab using ATE`K'_consistant.csv, replace b(%12.2f) se(%12.2f) not csv label star(* 0.10 ** 0.05 *** 0.01)  ///
		keep(	ATE ATE1 ATE2 ATE3 gamma gamma1 gamma2 gamma3)
	}		
************************************************************************************************************
* TABLE 1:
use DATAlong, clear
keep if TWOPANELIND==1
	merge m:1 hhid using temp1
	drop if diffm==.
gen cat=1000*CASTER1+100*poorR1+10*landlessR1+both_illiterateR1
foreach cat in 1000	1001	1010	1011	1100	1101	1110	1111	2000	2001	2010	2011	2100	2101	2110	2111{	
		quiet: count if cat==`cat'
		local n=r(N)
		di  "CASTE:" substr("`cat'",1,1) ", POOR:" substr("`cat'",2,1) ", LANDLESS:" substr("`cat'",3,1) ", BOTH ILLIT.:" substr("`cat'",4,1) ":"
 		di "N=`n'"
		}
************************************************************************************************************
* TABLE 2
use DATAlong, clear
keep if TWOPANELIND
keep aw_* individual hhid hhwtR* movie othermemberspresent*
reshape wide aw_*, i(hhid) j(individual) string
foreach var in aw_emp_index aw_fac_index {
	gen DIFFR1`var'_ABS=abs(`var'R1I2-`var'R1I1)
	gen DIFFR2`var'_ABS=abs(`var'R2I2-`var'R2I1)
	tab DIFFR1`var'_ABS [aw=hhwtR1]
	tab DIFFR2`var'_ABS [aw=hhwtR2]
	}
************************************************************************************************************
* TABLE 3:
use DATAlong, clear
desc aw_emp_indexR1 aw_fac_indexR1 gender educR1 castecodeR1  rel_*R1 close_*R1 pearlinR1 assethouseR1
xi, noomit: tabstat aw_emp_indexR1 aw_fac_indexR1 gender i.educR1 i.castecodeR1 rel_*R1 close_*R1 i.pearlinR1 assethouseR1 if TWOPANELIND==1 [aw=hhwtR1], by(hhcatR1) stats(N mean semean)  columns(statistics)
************************************************************************************************************
* TABLE 4:
use DATAlong, clear
keep if TWOPANELIND==1 & movie==1 
tabstat INDknowsR2 [aw=hhwtR1], by(hhcatR1) 			stats(N mean semean)
tabstat INDknowsR2 [aw=hhwtR1], by(landlessR1) 			stats(N mean semean)
tabstat INDknowsR2 [aw=hhwtR1], by(both_illiterateR1)	stats(N mean semean)
tabstat INDknowsR2 [aw=hhwtR1], by(CASTER1) 			stats(N mean semean)
tabstat INDknowsR2 [aw=hhwtR1], by(poorR1) 				stats(N mean semean)
tabstat INDwatchedmovieR2 [aw=hhwtR1], by(hhcatR1) 				stats(N mean semean)
tabstat INDwatchedmovieR2 [aw=hhwtR1], by(landlessR1) 			stats(N mean semean)
tabstat INDwatchedmovieR2 [aw=hhwtR1], by(both_illiterateR1)	stats(N mean semean)
tabstat INDwatchedmovieR2 [aw=hhwtR1], by(CASTER1) 				stats(N mean semean)
tabstat INDwatchedmovieR2 [aw=hhwtR1], by(poorR1) 				stats(N mean semean)
************************************************************************************************************
* ADD. 5.a. and 5.b.:
foreach K in  aw_emp_indexR1 aw_fac_indexR1  {
use DATAlong, clear
keep if TWOPANELIND==1
bys hhcatR1: 			reg `K' movie [aw=hhwtR1], robust
bys both_illiterateR1: 	reg `K' movie [aw=hhwtR1], robust 
bys CASTER1: 			reg `K' movie [aw=hhwtR1], robust 
bys landlessR1: 		reg `K' movie [aw=hhwtR1], robust
bys poorR1: 			reg `K' movie [aw=hhwtR1], robust
}
************************************************************************************************************
* ADD. 1.a. SIMULATION
clear
version 13.1
set seed 1000

capture program drop myboo
program define myboo, rclass
version 13.1

use DATAwide, clear
keep if TWOPANELIND==1

merge m:1 hhid using temp1
drop if diffm==.

gen 		individual="I1" if gender==0
replace 	individual="I2" if gender==1


	gen beta=1
	sum INDwatchedmovie if movie==1 & round=="R2", meanonly
	gen b=r(mean)
	local b=r(mean)
	sum aw_emp_index if movie==0 & round=="R2"
	gen alpha0=r(mean)
	local sigma=sqrt(r(Var))

	gen alpha1=alpha0+`1'
	
	gen ATE=(alpha1-alpha0)+beta
	sum ATE
	return scalar ATE=r(mean)	
	
	gen ITE=(alpha1-alpha0)
	sum ITE
	return scalar ITE=r(mean)		
	


	gen 	K=alpha0+(alpha1-alpha0)*movie+beta*INDwatchedmovie+`2'*gender+ rnormal(0,`sigma')		if round=="R2"
	replace K=alpha0										   +`2'*gender+ rnormal(0,`sigma')		if round=="R1"

	keep K indid round hhid individual INDwatchedmovie movie gender
	reshape wide K INDwatchedmovie, i(indid) j(round) string

	
	preserve
	keep KR1 KR2 hhid individual INDwatchedmovieR2 movie
	reshape wide KR1 KR2 INDwatchedmovieR2, i(hhid) j(individual) string
	
	gen diffm	=	INDwatchedmovieR2I2	-	INDwatchedmovieR2I1
	gen diffk	=	(KR2I2	-	KR1I2) - (KR2I1	-	KR1I1)
	reg diffk  diffm, nocons
	local beta1=_b[diffm]
	return scalar beta1=_b[diffm]	
	restore
	
	reg KR2 movie
	return scalar ITT=_b[movie]
	local ITT=_b[movie]
	
	
	gen LHS			=KR2-`beta1'	*INDwatchedmovieR2
	reg LHS 	movie			
	return scalar ITE1=_b[movie]			
	local  ITE1=_b[movie]	
	
	reg KR2 		movie	INDwatchedmovieR2, vce(robust)
	return scalar beta2=_b[INDwatchedmovieR2]
	local beta2=_b[INDwatchedmovieR2]	
	return scalar ITE2=_b[movie]
	local ITE2=_b[movie]
	

	
	ivregress 2sls KR2 (INDwatchedmovieR2=movie), robust first 
	local beta3=_b[INDwatchedmovieR2]

	
	reg KR2 movie	INDwatchedmovieR2 gender , robust
	return scalar beta4=_b[INDwatchedmovieR2]
	local beta4=_b[INDwatchedmovieR2]
	return scalar ITE4=_b[movie]
	local ITE4=_b[movie]
	
	return scalar ATE1=`beta1'+`ITE1'
	return scalar ATE2=`beta2'+`ITE2'
	return scalar LATE=`beta3'
	return scalar ATE4=`beta4'+`ITE4'

end

foreach spill in 0 2{
	foreach endo in 0 2{
			simulate  ITE=r(ITE) ATE=r(ATE) ITT=r(ITT) ///
			beta1=r(beta1) ITE1=r(ITE1) ATE1=r(ATE1)  ///
			beta2=r(beta2) ITE2=r(ITE2) ATE2=r(ATE2)  ///
			beta4=r(beta4) ITE4=r(ITE4) ATE4=r(ATE4)  ///
			LATE=r(LATE), reps(10) seed(1234): myboo `spill' `endo'
			gen simu="`spill'_`endo'"
			save SIMU_`spill'_`endo', replace
			ci _all
	}
}
use SIMU_0_0, clear
foreach spill in 0 2{
	foreach endo in 0 2{
if (`endo'==0 & `spill'==0)==0{
	append using SIMU_`spill'_`endo'
}
}
}
bys simu: ci _all



