! Fotran 90 code for the estimating the SCSAR model used in the simulation study of 
! "A Social Interactions Model with Endogenous Friendship Formation and Selectivity"
! forthcoming in Journal of Applied Econometrics. 
! 
! This f90 file should be complied along with the other three module files -- 
! SCSAR.f90, random.f90 contributed by Alan Miller, and tool.f90
! We specify the values of burn-in, total length of MCMC according to
! the design in the paper. Users can use different values.
!
! Written by 
! Chih-Sheng Hsieh
! Department of Economics
! The Chinese University of Hong Kong
! 11/17/2014
!
! Any question can be directed to cshsieh@cuhk.edu.hk
!
!*****************************************************************************************
    
    
    include 'mkl_vsl.f90'

    PROGRAM MAIN  

    USE                     random
    USE                     TOOL
    USE                     mkl95_LAPACK
    USE                     MKL_VSL_TYPE
    USE                     MKL_VSL
    USE                     omp_lib
    USE                     FULL_MCMC
    IMPLICIT NONE

    !****************** GENERAL VARIABLES ****************!

    CHARACTER(100)     :: path1='D:/research/social_interaction_model_with_selectivity/'
    CHARACTER(100)     :: path2='/simulation/data/small_network_double_variance/'
    CHARACTER(100)     :: path3='/simulation/result/small_network_double_variance/D3/'
    CHARACTER(40)      :: numchr1
    INTEGER, PARAMETER :: burn=20000, Nthreads=30, GG=60, TT=100000, THIN=10, MAX=50, RR=100,  H=5
    REAL, PARAMETER    :: pi=3.14159265
    REAL               :: c_1, c_2, acc_1, acc_2, rand, acc_4, c_0(GG), acc_0(GG), kk
    INTEGER            :: NN, N(GG),  k, q, count_one, count_two, count_three, Model_proposal , DD
    INTEGER            :: brng, method, me, i, j, g, t, d, flag, ier,  r, m, seedsize, seed(2), errorflag, INFO, seed_mkl, t_round
    INTEGER            :: clock_max, clock_rate, clock_start, clock_stop, ithread, iblock,ibegin,iend
    REAL, DIMENSION(MAX,MAX,GG):: C_raw, W_raw
    REAL, DIMENSION(MAX,GG):: X_raw, Y_raw
    REAL, ALLOCATABLE:: C(:,:), W(:,:), IPIV(:)
    INTEGER, ALLOCATABLE :: order(:),  INDX(:)
    REAL, ALLOCATABLE:: Y(:),X(:)
    LOGICAL            :: first=.true.
    TYPE (VSL_STREAM_STATE) :: stream
    INTEGER :: CODE, SEED_PERM
    INTEGER(kind=8)       ::  errcode
     

    !*** MC collections of parameters *******!

    REAL :: Mean_lam, Var_lam
    REAL :: Mean_bet(2), Var_bet(2,2)
    REAL :: Mean_alp(GG), Var_alp(GG,GG)
    REAL, ALLOCATABLE :: Mean_gam(:), Var_gam(:,:), Mean_sig(:), Var_sig(:,:), Mean_lat(:,:,:), Var_lat(:,:,:)
    REAL(kind=8)  :: Mean_logp(1)
    
    !*****************************************!

    REAL, ALLOCATABLE :: gamma_T(:,:)
    REAL              :: lambda_T(TT)  
    REAL              :: beta_T(2, TT)
    REAL              :: alpha_T(GG, TT)
    REAL, ALLOCATABLE :: sigma_T(:,:)
    REAL(kind=8)      :: logp_T(TT)

    !***********************************************************!

    seedsize=2
    seed(1)=2.1103e+005
    seed(2)=2.1103e+005
    CALL RANDOM_SEED
    CALL RANDOM_SEED(SIZE=seedsize)
    CALL RANDOM_SEED(PUT=seed)

    seed_mkl=12345
    brng=VSL_BRNG_MCG31
    method=VSL_METHOD_SGAUSSIANMV_BOXMULLER
    me=VSL_MATRIX_STORAGE_FULL

    errcode=vslnewstream(stream,brng,seed_mkl)  

    OPEN (50000, file =  trim(adjustl(path1)) // trim(adjustl(path3)) // 'gamma_R.txt', status='unknown') 
    OPEN (60000, file =  trim(adjustl(path1)) // trim(adjustl(path3)) // 'lambda_R.txt', status='unknown') 
    OPEN (70000, file =  trim(adjustl(path1)) // trim(adjustl(path3)) // 'beta_R.txt', status='unknown') 
    OPEN (80000, file =  trim(adjustl(path1)) // trim(adjustl(path3)) // 'sigma_R.txt', status='unknown') 
    

    DD=3

    DO r=1, RR   
        print*, 'r=', r
        WRITE(numchr1,*) r

        CALL networksize(GG, MAX, path1, path2, r, N)
        CALL define_variable(C_raw, X_raw, W_raw, Y_raw, GG, N, r, path1, path2, MAX)


        ALLOCATE(Mean_gam(DD+2));  ALLOCATE(Var_gam(DD+2,DD+2));   
        ALLOCATE(Mean_sig(DD+1));    ALLOCATE(Var_sig(DD+1,DD+1)); 
        ALLOCATE(Mean_lat(MAX,DD,GG));  ALLOCATE(Var_lat(MAX,DD,GG));
        ALLOCATE(zz_T(MAX,DD,GG,(TT-burn)/THIN))
        ALLOCATE(gamma_T(DD+2,TT));
        ALLOCATE(sigma_T(DD+1,TT));

        CALL  FULL_SCSAR (DD,H,r, TT, burn, THIN, gamma_T, lambda_T, beta_T, sigma_T, alpha_T, logp_T, Mean_lat, zz_T, method, stream, me)

        
        Mean_gam=sum(gamma_T(:,burn+1:TT),2)/(TT-burn)
        Mean_lam=sum(lambda_T(burn+1:TT))/(TT-burn)
        Mean_bet=sum(beta_T(:,burn+1:TT),2)/(TT-burn)
        Mean_sig=sum(sigma_T(:,burn+1:TT),2)/(TT-burn)
        Mean_alp=sum(alpha_T(:,burn+1:TT),2)/(TT-burn)
        Mean_logp=sum(logp_T(burn+1:TT))/(TT-burn)

        

        IF (DD==1) THEN
            write(50000,'(3f12.6)') Mean_gam
            write(60000,'(1f12.6)') Mean_lam
            write(70000,'(2f12.6)') Mean_bet
            write(80000,'(2f12.6)') Mean_sig
        ELSEIF (DD==2) THEN
            write(50000,'(4f12.6)') Mean_gam
            write(60000,'(1f12.6)') Mean_lam
            write(70000,'(2f12.6)') Mean_bet
            write(80000,'(3f12.6)') Mean_sig
        ELSEIF (DD==3) THEN
            write(50000,'(5f12.6)') Mean_gam
            write(60000,'(1f12.6)') Mean_lam
            write(70000,'(2f12.6)') Mean_bet
            write(80000,'(4f12.6)') Mean_sig
        END IF 
        
        
        DEALLOCATE(Mean_gam);  DEALLOCATE(Var_gam);   DEALLOCATE(Mean_sig);  DEALLOCATE(Var_sig); DEALLOCATE(Mean_lat)
        DEALLOCATE(Var_lat);   DEALLOCATE(zz_T);      DEALLOCATE(gamma_T);   DEALLOCATE(sigma_T);


    END DO

    
    CLOSE(50000)
    CLOSE(60000)
    CLOSE(70000)
    CLOSE(80000)
    
    END PROGRAM MAIN