    MODULE FULL_MCMC

    IMPLICIT NONE

    CONTAINS


    Subroutine FULL_SCSAR (DD,H,r, TT, burn, THIN, gamma_T, lambda_T, beta_T, sigma_T, alpha_T, logp_T, Mean_lat, zz_T, method, stream, me)


    USE                     random
    USE                     TOOL
    USE                     mkl95_LAPACK
    USE                     MKL_VSL_TYPE
    USE                     MKL_VSL
    USE                     omp_lib
    IMPLICIT NONE

    !****************** GENERAL VARIABLES ****************!

    CHARACTER(100)             :: path1='D:/research/2011_social_interaction_model_with_selectivity/submission_JAE/'
    CHARACTER(100)             :: path2='/simulation/data/small_network_double_variance/'
    CHARACTER(40)              :: numchr1
    INTEGER, PARAMETER         :: Nthreads=30, MAX=50, GG=60
    INTEGER                    ::  DD, H,r, burn, TT, THIN
    REAL, PARAMETER            :: pi=3.14159265
    REAL                       :: c_1, c_2, acc_1, acc_2, rand, c_3(GG), acc_3(GG),  acc_4, acc_3v , c_0(GG), acc_0(GG), kk, t_unround 
    INTEGER                    ::   NN, N(GG),  k 
    INTEGER                    :: brng, method, me, i, j, g, t, d, flag, ier,  m, seedsize, seed(2), errorflag, INFO, seed_mkl, t_round
    INTEGER                    :: clock_max, clock_rate, clock_start, clock_stop, ithread, iblock,ibegin,iend
    REAL, DIMENSION(MAX,MAX,GG):: C_raw, W_raw
    REAL, DIMENSION(MAX,GG)    :: X_raw, Y_raw
    REAL, ALLOCATABLE          :: C(:,:), W(:,:), IPIV(:)
    INTEGER, ALLOCATABLE       :: order(:),  INDX(:)
    REAL, ALLOCATABLE          :: Y(:),X(:)
    LOGICAL                    :: first=.true.
    TYPE (VSL_STREAM_STATE)    :: stream
    INTEGER                    :: CODE, DD1, DD2, SEED_PERM
    INTEGER                    ::  errcode
    REAL(kind=8)               :: det1, det2, pp


    !*** hyperparameters in the prior distribution ***!
    REAL, DIMENSION(2+DD)      :: gamma_0
    REAL, DIMENSION(2)         :: beta_0
    REAL, DIMENSION(2+DD,2+DD) :: G_0
    REAL, DIMENSION(2,2)       :: B_0, INV_B_0
    REAL, DIMENSION(1+DD)      :: sigma_0
    REAL, DIMENSION(1+DD,1+DD) :: Sig_0
    REAL                       ::  eta_0, ALPHA_0, a_0
    INTEGER                    ::  rho_0

    !*** MC collections of parameters *******!

    REAL :: Mean_gam(DD+2), Var_gam(DD+2,DD+2)
    REAL :: Mean_lam, Var_lam  
    REAL :: Mean_bet(2), Var_bet(2,2)
    REAL :: Mean_sig(DD+1), Var_sig(DD+1,DD+1)
    REAL :: Mean_alp(GG), Var_alp(GG,GG)
    REAL, DIMENSION(MAX, DD,GG) :: Mean_lat, Var_lat
    REAL(KIND=8) :: Mean_logp(1), Var_logp(1), AICM(1) 


    !*** posterior draws of parameters *******!

    REAL, DIMENSION(2+DD,TT) :: gamma_T
    REAL, DIMENSION(TT)      :: lambda_T, acc_rate1, acc_rate2, acc_rate4
    REAL, DIMENSION(2, TT)   :: beta_T
    REAL, DIMENSION(1+DD,TT) :: sigma_T
    REAL, DIMENSION(GG,TT)   :: alpha_T, acc_rate3
    REAL(KIND=8)             :: logp_T(TT)

    !******  VARIABLE IN M-H FOR Z_G  *******************************!

    REAL, DIMENSION(MAX,DD,GG, (TT-burn)/THIN) :: zz_T
    REAL, DIMENSION(MAX,DD,GG) :: zz_mean, zz, zz_temp, zz_var, zz_temp2
    REAL, ALLOCATABLE  :: zz_1(:,:), zz_2(:,:), V(:,:), S1(:,:), S2(:,:), XX(:,:),  cov_zz(:,:), temp_zz(:)
    REAL, ALLOCATABLE  :: V1(:,:), V2(:,:)
    REAL, ALLOCATABLE  :: psi(:,:), psi_1(:,:), psi_2(:,:),zero(:)
    REAL, ALLOCATABLE  :: ep(:), ep_1(:), ep_2(:)
    REAL, ALLOCATABLE  :: ep_1v(:), ep_2v(:)
    INTEGER :: w1, w2, w3, w4
    REAL(kind=8) :: like_Y1, like_Y2, q_1, q_2


    !********VARIABLE IN M-H FOR GAMMA & LAMBDA   ***************!

    REAL   :: lambda_1, lambda_2
    REAL   :: gamma_1(2+DD), gamma_2(2+DD), COV_gamma_1(2+DD,2+DD)
    REAL(kind=8) ::  pp_l(GG), pp_G(GG), pp_sig(GG)
    !*************VARIABLE IN M-H FOR BETA **************!

    REAL :: XVX(2,2,GG), XVY(2,GG), INV_B(2,2), INV_B2(2,2), beta_temp(2)
    REAL, ALLOCATABLE ::  XX2(:,:), YY(:), S(:,:) 

    !*************VARIABLE IN M-H FOR SIGMA_E & SIGMA_EZ & ALPHA_G**************!

    REAL              :: sigma_1(1+DD), sigma_2(1+DD), COV_sigma_1(1+DD,1+DD)
    REAL              :: R_g 
    REAL, ALLOCATABLE :: VV1(:,:), VV2(:,:)

    !***********************************************************!



    gamma_0=0.0
    beta_0=0.0
    G_0=eye(2+DD)*10.0
    Sig_0=eye(1+DD)*10.0
    B_0=eye(2)*10.0
    CALL FINDInv(B_0,INV_B_0,2,ier)
    ALPHA_0=100.0
    a_0=0.0
    eta_0=0.1
    rho_0=2            
    sigma_0(1)=1.0
    sigma_0(2:DD+1)=0.0


    CALL networksize(GG, MAX, path1, path2, r, N)
    CALL define_variable(C_raw, X_raw, W_raw, Y_raw, GG, N, r, path1, path2, MAX)


    ! initial value of the draws !
    zz=0.0
    IF (DD==1) THEN
        gamma_T(:,1)=(/-0.5, 0.5, 1.0/)
        sigma_T(1,1)=1.0
        sigma_T(2,1)=0.3
    ELSEIF (DD==2) THEN
        gamma_T(:,1)=(/-0.5, 1.0, 2.0, 1.0/)
        sigma_T(1,1)=1.0
        sigma_T(2,1)=0.0
        sigma_T(3,1)=0.5
    ELSEIF (DD==3) THEN
        gamma_T(:,1)=(/-0.5, 1.0, 2, 1.0, 0.0/)
        sigma_T(1,1)=1.0
        sigma_T(2,1)=0.0
        sigma_T(3,1)=0.5
        sigma_T(4,1)=0.0
    ENDIF 
    zz=0.0
    zz_mean=0.0
    zz_T=0.0
    c_3=0.01
    acc_3=0.0
    acc_1=0
    acc_2=0
    acc_4=0



    DO t=2, TT
        call system_clock ( clock_start, clock_rate, clock_max )

        DO 
            lambda_1=random_normal()*0.1+lambda_T(t-1)
            IF (t>2) THEN  
                lambda_2=random_normal()*sqrt(var(lambda_T(1:t-1),t-1))*2.38+lambda_T(t-1)
                lambda_1=0.95*lambda_2+0.05*lambda_1
            END IF  
            IF ((lambda_1>=-0.10) .and. (lambda_1<=0.10)) EXIT  
        END DO        


        DO 
            COV_gamma_1=EYE(2+DD)*0.01/(2+DD)
            call spotrf('U',2+DD, COV_gamma_1, 2+DD, info)             
            errcode=vsrnggaussianmv(method,stream,1,gamma_1, 2+DD, me, gamma_0, COV_gamma_1) 
            gamma_1=gamma_1+gamma_T(:,t-1)
            IF (t>2*(2+DD)) THEN  
                COV_gamma_1=cov(gamma_T(:,1:t-1),2+DD,t-1)*2.38**2/(2+DD)
                call spotrf('U',2+DD, COV_gamma_1, 2+DD, info)             
                errcode=vsrnggaussianmv(method,stream,1,gamma_2, 2+DD, me, gamma_0, COV_gamma_1)
                gamma_2=gamma_2+gamma_T(:,t-1)           
                gamma_1=0.95*gamma_2+0.05*gamma_1
            END IF
            IF (DD==1) THEN
                IF (gamma_1(2+DD)>=0) EXIT
            ELSEIF (DD==2) THEN
                IF ((gamma_1(1+DD)>=gamma_1(2+DD)) )   EXIT
            ELSEIF (DD==3) THEN
                IF ((gamma_1(DD)>=gamma_1(1+DD)) .and. (gamma_1(1+DD)>=gamma_1(2+DD)) ) EXIT
            ELSEIF (DD==4)  THEN   
                IF ((gamma_1(DD-1)>=gamma_1(DD)) .and. (gamma_1(DD)>=gamma_1(1+DD)) .and. (gamma_1(1+DD)>=gamma_1(2+DD)) ) EXIT
            END IF 
        END DO

        gamma_2=gamma_T(:,t-1)



        !***** THE M-H ALGORITHM FOR SAMPLING Z ******!

        Call OMP_SET_NUM_THREADS(Nthreads)

        !$omp parallel default(shared) private(g, NN,V, S, Y,X, XX, W,&
        !$omp & psi_1, psi_2, ep, ep_1, ep_2, ep_1v, ep_2v, S1, S2, INFO, CODE, DD1, DD2, &
        !$omp & c, V1, V2, zz_1, zz_2, IPIV, INDX, det1, det2, q_1, q_2, &
        !$omp & kk, acc_3v, k, cov_zz, temp_zz, zero, d, pp, i, j, like_Y1, like_Y2, rand, &
        !$omp & ithread, iblock, ibegin, iend) 

        ithread = OMP_GET_THREAD_NUM()
        iblock = (GG+Nthreads-1)/Nthreads
        ibegin = ithread*iblock+1
        iend = min((ithread+1)*iblock,GG)

        DO g = ibegin,iend

            NN=N(g)
            ALLOCATE(V(NN,NN));    
            ALLOCATE(C(NN,NN))
            ALLOCATE(W(NN,NN));    ALLOCATE(Y(NN))
            ALLOCATE(X(NN));       ALLOCATE(XX(NN,2))
            ALLOCATE(S1(NN,NN));   ALLOCATE(S2(NN,NN))
            ALLOCATE(zz_1(NN,DD));     ALLOCATE(zz_2(NN,DD))
            ALLOCATE(V1(NN,NN));   ALLOCATE(V2(NN,NN))
            ALLOCATE(ep_1(NN));    ALLOCATE(ep_2(NN)) 
            ALLOCATE(ep_1v(NN));   ALLOCATE(ep_2v(NN))
            ALLOCATE(IPIV(NN));        ALLOCATE(INDX(NN));    
            ALLOCATE(psi_1(NN,NN));ALLOCATE(psi_2(NN,NN)) 


            V=(sigma_T(1,t-1)-sum(sigma_T(2:DD+1,t-1)*sigma_T(2:DD+1,t-1)))*EYE(NN)
            C=C_raw(1:NN,1:NN,g)
            W=W_raw(1:NN,1:NN,g)
            Y=Y_raw(1:NN,g)
            X=X_raw(1:NN,g)
            zz_1=zz(1:NN,1:DD,g)
            zz_2=zz(1:NN,1:DD,g)

            S1=eye(NN)-lambda_T(t-1)*W  

            XX(:,1)=X
            XX(:,2)=matmul(W,X)

            kk=NN
            kk=floor(kk/H)        
            IF (kk==0) kk=kk+1 

            acc_3v=0.0
            DO k=1, kk
                IF(k==kk) THEN
                    ALLOCATE(cov_zz(NN-(k-1)*H,NN-(k-1)*H))
                    ALLOCATE(temp_zz(NN-(k-1)*H))       
                    ALLOCATE(zero(NN-(k-1)*H))
                    zero=0.0
                    cov_zz=EYE(NN-(k-1)*H)*c_3(g)
                    call spotrf('U',NN-(k-1)*H, cov_zz, NN-(k-1)*H, info)     
                    DO d=1, DD  
                        errcode=vsrnggaussianmv(method,stream, 1, temp_zz, NN-(k-1)*H, me, zero, cov_zz) 
                        zz_1((k-1)*H+1:NN,d)=temp_zz+zz_2((k-1)*H+1:NN,d)
                    END DO
                    DEALLOCATE(cov_zz)
                    DEALLOCATE(temp_zz)
                    DEALLOCATE(zero)
                ELSE
                    ALLOCATE(cov_zz(H,H))
                    ALLOCATE(temp_zz(H))  
                    ALLOCATE(zero(H))
                    zero=0.0
                    cov_zz=EYE(H)*c_3(g)
                    call spotrf('U',H, cov_zz, H, info) 
                    DO d=1,DD                               
                        errcode=vsrnggaussianmv(method,stream, 1, temp_zz, H, me, zero, cov_zz) 
                        zz_1((k-1)*H+1:k*H,d)=temp_zz+zz_2((k-1)*H+1:k*H,d)
                    END DO
                    DEALLOCATE(cov_zz)
                    DEALLOCATE(temp_zz)
                    DEALLOCATE(zero)
                END IF


                pp=0.0
                DO i=1,NN
                    DO j=1,NN
                        IF (j/=i) THEN
                            IF (DD==1) THEN                        
                                psi_1(i,j)=gamma_T(1,t-1)+gamma_T(2,t-1)*C(i,j)-gamma_T(3,t-1)*abs(zz_1(i,1)-zz_1(j,1))                                 
                                psi_2(i,j)=gamma_T(1,t-1)+gamma_T(2,t-1)*C(i,j)-gamma_T(3,t-1)*abs(zz_2(i,1) -zz_2(j,1))
                            ELSEIF (DD==2) THEN
                                psi_1(i,j)=gamma_T(1,t-1)+gamma_T(2,t-1)*C(i,j)-gamma_T(3,t-1)*abs(zz_1(i,1)-zz_1(j,1))-gamma_T(4,t-1)*abs(zz_1(i,2)-zz_1(j,2))                                 
                                psi_2(i,j)=gamma_T(1,t-1)+gamma_T(2,t-1)*C(i,j)-gamma_T(3,t-1)*abs(zz_2(i,1)-zz_2(j,1))-gamma_T(4,t-1)*abs(zz_2(i,2)-zz_2(j,2))
                            ELSEIF (DD==3) THEN
                                psi_1(i,j)=gamma_T(1,t-1)+gamma_T(2,t-1)*C(i,j)-gamma_T(3,t-1)*abs(zz_1(i,1)-zz_1(j,1)) -gamma_T(4,t-1)*abs(zz_1(i,2)-zz_1(j,2)) &
                                &  -gamma_T(5,t-1)*abs(zz_1(i,3)-zz_1(j,3))                                             
                                psi_2(i,j)=gamma_T(1,t-1)+gamma_T(2,t-1)*C(i,j)-gamma_T(3,t-1)*abs(zz_2(i,1)-zz_2(j,1)) -gamma_T(4,t-1)*abs(zz_2(i,2)-zz_2(j,2)) &
                                &  -gamma_T(5,t-1)*abs(zz_2(i,3)-zz_2(j,3))
                            ELSEIF (DD==4) THEN
                                psi_1(i,j)=gamma_T(1,t-1)+gamma_T(2,t-1)*C(i,j)-gamma_T(3,t-1)*abs(zz_1(i,1)-zz_1(j,1))  -gamma_T(4,t-1)*abs(zz_1(i,2)-zz_1(j,2)) &
                                &    -gamma_T(5,t-1)*abs(zz_1(i,3)-zz_1(j,3)) -gamma_T(6,t-1)*abs(zz_1(i,4)-zz_1(j,4)) 
                                psi_2(i,j)=gamma_T(1,t-1)+gamma_T(2,t-1)*C(i,j)-gamma_T(3,t-1)*abs(zz_2(i,1)-zz_2(j,1)) -gamma_T(4,t-1)*abs(zz_2(i,2)-zz_2(j,2))  &
                                &   -gamma_T(5,t-1)*abs(zz_2(i,3)-zz_2(j,3)) -gamma_T(6,t-1)*abs(zz_2(i,4)-zz_2(j,4))                             
                            ENDIF

                            q_1=psi_1(i,j)*W(i,j)-log(1+exp(psi_1(i,j)))
                            q_2=psi_2(i,j)*W(i,j)-log(1+exp(psi_2(i,j)))
                            pp=pp+(q_1-q_2)
                        ENDIF
                    END DO
                END DO


                ep_1=matmul(S1,Y)-matmul(XX,beta_T(:,t-1))-alpha_T(g,t-1)-matmul(zz_1,sigma_T(2:DD+1,t-1))
                ep_2=matmul(S1,Y)-matmul(XX,beta_T(:,t-1))-alpha_T(g,t-1)-matmul(zz_2,sigma_T(2:DD+1,t-1))
                ep_1v=ep_1; ep_2v=ep_2
                V1=V; V2=V


                CALL SGESV(NN,1,V1,NN,IPIV,ep_1v,NN,INFO)
                CALL SGESV(NN,1,V2,NN,IPIV,ep_2v,NN,INFO)

                like_Y1=-dot_product(ep_1, ep_1v)/2
                like_Y2=-dot_product(ep_2, ep_2v)/2

                IF (k==kk) THEN
                    pp=pp+(like_Y1-like_Y2)+logmvnpdf(reshape(zz_1((k-1)*H+1:NN,:),(/(NN-(k-1)*H)*DD,1/)),eye((NN-(k-1)*H)*DD),(NN-(k-1)*H)*DD)-logmvnpdf(reshape(zz_2((k-1)*H+1:NN,:),(/(NN-(k-1)*H)*DD,1/)),eye((NN-(k-1)*H)*DD),(NN-(k-1)*H)*DD)
                ELSE
                    pp=pp+(like_Y1-like_Y2)+logmvnpdf(reshape(zz_1((k-1)*H+1:k*H,:),(/H*DD,1/)),eye(H*DD),H*DD)-logmvnpdf(reshape(zz_2((k-1)*H+1:k*H,:),(/H*DD,1/)),eye(H*DD),H*DD)          
                END IF

                CALL random_number(rand)                 
                IF (log(rand)<=pp) THEN
                    zz_2=zz_1
                    acc_3v=acc_3v+1
                END IF            
                zz_1=zz_2            
            END DO 


            if (3*acc_3v>1*kk) acc_3(g)=acc_3(g)+1
            acc_rate3(g,t)=acc_3(g)/t
            if ((acc_rate3(g,t)<0.2) )  c_3(g)=c_3(g)/1.01
            if ((acc_rate3(g,t)>0.3) )  c_3(g)=c_3(g)*1.01
            zz(1:NN,1:DD,g)=zz_1

            t_unround=(t-burn)/(THIN+0.0)
            t_round=(t-burn)/THIN

            IF ( ((t_unround*THIN-t_round*THIN)==0) .AND. (t_unround)>=1.0) THEN
                zz_T(1:NN,1:DD,g,(t-burn)/THIN)=zz(1:NN,1:DD,g)          
            END IF 

            IF ((t-burn)==2) THEN
                zz_mean(:,:,g)=zz(:,:,g)
            ELSEIF ((t-burn)>=3) THEN
                zz_temp(:,:,g)=zz_mean(:,:,g)
                zz_mean(:,:,g)=zz_temp(:,:,g)+(zz(:,:,g)-zz_temp(:,:,g))/((t-burn)-1)
            ENDIF



            !***** THE M-H ALGORITHM FOR SAMPLING GAMMA & LAMBDA ******!

            pp=0.0
            DO i=1,NN
                DO j=1, NN
                    IF (j/=i) THEN
                        IF (DD==1) THEN
                            psi_1(i,j)=gamma_1(1)+gamma_1(2)*c(i,j)-gamma_1(3)*abs(zz_1(i,1)-zz_1(j,1))
                            psi_2(i,j)=gamma_2(1)+gamma_2(2)*c(i,j)-gamma_2(3)*abs(zz_1(i,1)-zz_1(j,1))
                        ELSEIF (DD==2) THEN
                            psi_1(i,j)=gamma_1(1)+gamma_1(2)*c(i,j)-gamma_1(3)*abs(zz_1(i,1)-zz_1(j,1))-gamma_1(4)*abs(zz_1(i,2)-zz_1(j,2))
                            psi_2(i,j)=gamma_2(1)+gamma_2(2)*c(i,j)-gamma_2(3)*abs(zz_1(i,1)-zz_1(j,1))-gamma_2(4)*abs(zz_1(i,2)-zz_1(j,2))
                        ELSEIF (DD==3) THEN
                            psi_1(i,j)=gamma_1(1)+gamma_1(2)*c(i,j)-gamma_1(3)*abs(zz_1(i,1)-zz_1(j,1))-gamma_1(4)*abs(zz_1(i,2)-zz_1(j,2)) &
                            & -gamma_1(5)*abs(zz_1(i,3)-zz_1(j,3)) 
                            psi_2(i,j)=gamma_2(1)+gamma_2(2)*c(i,j)-gamma_2(3)*abs(zz_1(i,1)-zz_1(j,1))-gamma_2(4)*abs(zz_1(i,2)-zz_1(j,2)) &
                            & -gamma_2(5)*abs(zz_1(i,3)-zz_1(j,3)) 
                        ELSEIF (DD==4) THEN
                            psi_1(i,j)=gamma_1(1)+gamma_1(2)*c(i,j)-gamma_1(3)*abs(zz_1(i,1)-zz_1(j,1))-gamma_1(4)*abs(zz_1(i,2)-zz_1(j,2)) &
                            &   -gamma_1(5)*abs(zz_1(i,3)-zz_1(j,3))-gamma_1(6)*abs(zz_1(i,4)-zz_1(j,4))
                            psi_2(i,j)=gamma_2(1)+gamma_2(2)*c(i,j)-gamma_2(3)*abs(zz_1(i,1)-zz_1(j,1))-gamma_2(4)*abs(zz_1(i,2)-zz_1(j,2)) &
                            &   -gamma_2(5)*abs(zz_1(i,3)-zz_1(j,3))-gamma_2(6)*abs(zz_1(i,4)-zz_1(j,4))
                        ENDIF
                        q_1=psi_1(i,j)*W(i,j)-log(1+exp(psi_1(i,j)))
                        q_2=psi_2(i,j)*W(i,j)-log(1+exp(psi_2(i,j)))
                        pp=pp+(q_1-q_2)
                    ENDIF
                END DO 
            END DO
            pp_G(g)=pp


            XX(:,1)=X
            XX(:,2)=matmul(W,X)

            S1=eye(NN)-lambda_1*W             
            S2=eye(NN)-lambda_T(t-1)*W          
            ep_1=matmul(S1,Y)-matmul(XX,beta_T(:,t-1))-matmul(zz_1,sigma_T(2:DD+1,t-1))-alpha_T(g,t-1)
            ep_2=matmul(S2,Y)-matmul(XX,beta_T(:,t-1))-matmul(zz_1,sigma_T(2:DD+1,t-1))-alpha_T(g,t-1)

            ep_1v=ep_1
            ep_2v=ep_2  
            V1=V
            V2=V


            CALL SGESV(NN,1,V1,NN,IPIV,ep_1v,NN,INFO)
            CALL SGESV(NN,1,V2,NN,IPIV,ep_2v,NN,INFO)

            det1=FindDet(S1, NN)
            det2=FindDet(S2, NN)

            like_Y1=log(det1)-dot_product(ep_1, ep_1v)/2
            like_Y2=log(det2)-dot_product(ep_2, ep_2v)/2


            pp_l(g)=like_Y1-like_Y2  


            DEALLOCATE(V);         
            DEALLOCATE(S1);       DEALLOCATE(S2); 
            DEALLOCATE(Y);        DEALLOCATE(C);
            DEALLOCATE(X) ;       DEALLOCATE(XX) ;
            DEALLOCATE(W);  
            DEALLOCATE(psi_1);    DEALLOCATE(psi_2)
            DEALLOCATE(ep_1);     DEALLOCATE(ep_2);    
            DEALLOCATE(ep_1v);    DEALLOCATE(ep_2v)  ;
            DEALLOCATE(V1);       DEALLOCATE(V2)  ;
            DEALLOCATE(zz_1);     DEALLOCATE(zz_2) 
            DEALLOCATE(IPIV);     DEALLOCATE(INDX);   

        END DO
        !$omp end parallel   


        pp=sum(pp_G)+logmvnpdf(gamma_1, G_0, 2+DD)-logmvnpdf(gamma_2, G_0, 2+DD)

        CALL random_number(rand) 
        IF (log(rand)<=pp) THEN
            gamma_T(:,t)=gamma_1
            acc_1=acc_1+1.0
        ELSE
            gamma_T(:,t)=gamma_T(:,t-1)
        ENDIF
        acc_rate1(t)=acc_1/t 

        CALL random_number(rand) 
        IF (log(rand)<=sum(pp_l)) THEN 
            lambda_T(t)=lambda_1
            acc_2=acc_2+1.0
        ELSE
            lambda_T(t)=lambda_T(t-1)
        END IF
        acc_rate2(t)=acc_2/t 


        !***************GIBBS STEP TO SIMULTE BETA *********************!


        XVX=0.0
        XVY=0.0
        Call OMP_SET_NUM_THREADS(Nthreads)
        !$omp parallel default(shared) private(g,NN, V, Y, YY, &
        !$omp & X, XX, XX2, W, S1, V1, V2, zz_1, IPIV, INFO, &
        !$omp & ithread, iblock, ibegin, iend) 

        ithread = OMP_GET_THREAD_NUM()
        iblock = (GG+Nthreads-1)/Nthreads
        ibegin = ithread*iblock+1
        iend = min((ithread+1)*iblock,GG)

        DO g = ibegin,iend

            NN=N(g)
            ALLOCATE(V(NN,NN))       
            ALLOCATE(W(NN,NN));    ALLOCATE(Y(NN))
            ALLOCATE(X(NN));       ALLOCATE(YY(NN))  
            ALLOCATE(S1(NN,NN));    ALLOCATE(XX(NN,2))
            ALLOCATE(XX2(NN,2));  ALLOCATE(zz_1(NN,DD)) 
            ALLOCATE(V1(NN,NN));   ALLOCATE(V2(NN,NN))
            ALLOCATE(IPIV(NN))

            V=(sigma_T(1,t-1)-sum(sigma_T(2:DD+1,t-1)*sigma_T(2:DD+1,t-1)))*EYE(NN)
            W=W_raw(1:NN,1:NN,g)
            Y=Y_raw(1:NN,g)
            X=X_raw(1:NN,g)
            zz_1=zz(1:NN,1:DD,g)       

            S1=eye(NN)-lambda_T(t)*W        
            XX(:,1)=X
            XX(:,2)=matmul(W,X)
            XX2=XX        
            V1=V
            CALL SGESV(NN,2,V1,NN,IPIV,XX2,NN,INFO)
            YY=matmul(S1,Y)-matmul(zz_1,sigma_T(2:DD+1,t-1))-alpha_T(g,t-1)
            V2=V
            CALL SGESV(NN,1,V2,NN,IPIV,YY,NN,INFO)

            XVX(:,:,g)=XVX(:,:,g)+matmul(transpose(XX) , XX2)
            XVY(:,g)=XVY(:,g)+matmul(transpose(XX) , YY)  

            DEALLOCATE(V)       
            DEALLOCATE(W);    DEALLOCATE(Y)
            DEALLOCATE(X);    DEALLOCATE(YY)  
            DEALLOCATE(S1);    DEALLOCATE(XX)
            DEALLOCATE(XX2);  DEALLOCATE(zz_1) 
            DEALLOCATE(V1);   DEALLOCATE(V2)
            DEALLOCATE(IPIV)

        END DO
        !$omp end parallel  

        CALL FINDInv(sum(XVX,3)+INV_B_0,INV_B,2,ier)   
        INV_B2=INV_B

        CALL spotrf('U',2, INV_B2, 2, info)
        errcode=vsrnggaussianmv(method, stream, 1, beta_temp, 2, me, beta_0,  INV_B2)    
        beta_T(:,t)=beta_temp+matmul(INV_B,sum(XVY,2))


        !**********MH STEP TO SIMULTE SIGMA *********************!

        ALLOCATE(zero(1+DD))
        zero=0.0
        DO      
            COV_sigma_1=EYE(1+DD)*0.01/(1+DD)
            call spotrf('U',1+DD, COV_sigma_1, 1+DD, info)             
            errcode=vsrnggaussianmv(method,stream,1,sigma_1, 1+DD, me, zero, COV_sigma_1) 
            sigma_1=sigma_1+sigma_T(:,t-1)

            IF (t>2*(1+DD)) THEN  
                COV_sigma_1=cov(sigma_T(:,1:t-1),1+DD,t-1)*2.38**2/(1+DD)
                call spotrf('U',1+DD, COV_sigma_1, 1+DD, info)             
                errcode=vsrnggaussianmv(method,stream, 1, sigma_2, 1+DD, me, zero, COV_sigma_1)
                sigma_2=sigma_2+sigma_T(:,t-1)
                sigma_1=0.95*sigma_2+0.05*sigma_1
            END IF
            IF (DD==1) THEN
                IF( (sigma_1(1)>=sum(sigma_1(2:DD+1)*sigma_1(2:DD+1))) .and. (sigma_1(2)>=0) ) EXIT
            ELSEIF (DD==2) THEN
                IF( (sigma_1(1)>=sum(sigma_1(2:DD+1)*sigma_1(2:DD+1))) .and. (sigma_1(2)>=0) .and. (sigma_1(3)>=0) ) EXIT
            ELSEIF (DD==3) THEN
                IF( (sigma_1(1)>=sum(sigma_1(2:DD+1)*sigma_1(2:DD+1))) .and. (sigma_1(2)>=0) .and. (sigma_1(3)>=0) .and. (sigma_1(4)>=0) ) EXIT
            ELSEIF (DD==4)  THEN   
                IF( (sigma_1(1)>=sum(sigma_1(2:DD+1)*sigma_1(2:DD+1))) .and. (sigma_1(2)>=0) .and. (sigma_1(3)>=0) .and. (sigma_1(4)>=0)  .and. (sigma_1(5)>=0) ) EXIT
            END IF                   
        END DO
        DEALLOCATE(zero)

        Call OMP_SET_NUM_THREADS(Nthreads)
        !$omp parallel default(shared) private(g,NN, S1, V1, V2, Y, VV1, VV2, &
        !$omp &  zz_1, X, XX, W, ep_1, ep_2, ep_1v, ep_2v, IPIV, INFO, like_Y1, like_Y2, &
        !$omp & ithread, iblock, ibegin, iend) 

        ithread = OMP_GET_THREAD_NUM()
        iblock = (GG+Nthreads-1)/Nthreads
        ibegin = ithread*iblock+1
        iend = min((ithread+1)*iblock,GG)

        DO g = ibegin,iend

            NN=N(g)
            ALLOCATE(V1(NN,NN));   ALLOCATE(V2(NN,NN)) 
            ALLOCATE(VV1(NN,NN));ALLOCATE(VV2(NN,NN))  
            ALLOCATE(W(NN,NN));    ALLOCATE(Y(NN))
            ALLOCATE(X(NN));           ALLOCATE(XX(NN,2)) 
            ALLOCATE(S1(NN,NN));     ALLOCATE(zz_1(NN,DD))
            ALLOCATE(ep_1(NN));      ALLOCATE(ep_2(NN))
            ALLOCATE(ep_1v(NN));    ALLOCATE(ep_2v(NN))
            ALLOCATE(IPIV(NN))

            V1=(sigma_1(1)-sum(sigma_1(2:DD+1)*sigma_1(2:DD+1)))*EYE(NN)
            V2=(sigma_T(1,t-1)-sum(sigma_T(2:DD+1,t-1)*sigma_T(2:DD+1,t-1)))*EYE(NN)
            W=W_raw(1:NN,1:NN,g)
            Y=Y_raw(1:NN,g)
            X=X_raw(1:NN,g)
            zz_1=zz(1:NN,1:DD,g)
            XX(:,1)=X
            XX(:,2)=matmul(W,X)


            S1=eye(NN)-lambda_T(t)*W
            ep_1=matmul(S1,Y)-matmul(XX,beta_T(:,t))-matmul(zz_1,sigma_1(2:DD+1))-alpha_T(g,t-1)
            ep_2=matmul(S1,Y)-matmul(XX,beta_T(:,t))-matmul(zz_1,sigma_T(2:DD+1,t-1))-alpha_T(g,t-1)
            ep_1v=ep_1
            ep_2v=ep_2


            VV1=V1
            VV2=V2
            CALL SGESV(NN,1,VV1,NN,IPIV,ep_1v,NN,INFO)
            CALL SGESV(NN,1,VV2,NN,IPIV,ep_2v,NN,INFO)


            like_Y1=(-0.5)*NN*log(sigma_1(1)-sum(sigma_1(2:DD+1)*sigma_1(2:DD+1)))-dot_product(ep_1, ep_1v)/2
            like_Y2=(-0.5)*NN*log(sigma_T(1,t-1)-sum(sigma_T(2:DD+1,t-1)*sigma_T(2:DD+1,t-1)))-dot_product(ep_2, ep_2v)/2


            pp_sig(g)=(like_Y1-like_Y2)

            DEALLOCATE(V1);   DEALLOCATE(V2) 
            DEALLOCATE(VV1);  DEALLOCATE(VV2)  
            DEALLOCATE(W);    DEALLOCATE(Y)
            DEALLOCATE(X);    DEALLOCATE(XX) 
            DEALLOCATE(S1);    DEALLOCATE(zz_1) 
            DEALLOCATE(ep_1); DEALLOCATE(ep_2)
            DEALLOCATE(ep_1v);DEALLOCATE(ep_2v)
            DEALLOCATE(IPIV)        
        END DO
        !$omp end parallel 
        pp=sum(pp_sig)+logmvnpdf( sigma_1-sigma_0, Sig_0, 1+DD)-logmvnpdf(sigma_T(1:1+DD,t-1)-sigma_0, Sig_0, 1+DD) 

        CALL random_number(rand) 
        IF (log(rand)<=pp) THEN
            sigma_T(:,t)=sigma_1
            acc_4=acc_4+1.0
        ELSE
            sigma_T(:,t)=sigma_T(:,t-1)
        ENDIF
        acc_rate4(t)=acc_4/t 


        !*************GIBBS STEP FOR ALPHA_G*********************!


        Call OMP_SET_NUM_THREADS(Nthreads)
        !$omp parallel default(shared) private(g,NN, Y, YY, &
        !$omp & X, XX, W, S1, zz_1, IPIV, R_g, &
        !$omp & ithread, iblock, ibegin, iend) 

        ithread = OMP_GET_THREAD_NUM()
        iblock = (GG+Nthreads-1)/Nthreads
        ibegin = ithread*iblock+1
        iend = min((ithread+1)*iblock,GG)

        DO g = ibegin,iend
            NN=N(G)              
            ALLOCATE(W(NN,NN));         ALLOCATE(Y(NN))
            ALLOCATE(X(NN));                ALLOCATE(XX(NN,2))      
            ALLOCATE(S1(NN,NN));          ALLOCATE(YY(NN))  
            ALLOCATE(zz_1(NN,DD))

            R_g=(ALPHA_0**(-1)+(sigma_T(1,t)-sum(sigma_T(2:DD+1,t)*sigma_T(2:DD+1,t)))**(-1.0)*NN)**(-1.0) 
            W=W_raw(1:NN,1:NN,g)
            Y=Y_raw(1:NN,g)
            X=X_raw(1:NN,g)
            zz_1=zz(1:NN,1:DD,g)

            S1=eye(NN)-lambda_T(t)*W
            YY=matmul(S1,Y)-matmul(zz_1,sigma_T(2:DD+1,t))
            XX(:,1)=X 
            XX(:,2)=matmul(W,X)
            alpha_T(g,t)=R_g*(ALPHA_0**(-1)*a_0+(sigma_T(1,t)-sum(sigma_T(2:DD+1,t)*sigma_T(2:DD+1,t)))**(-1.0)*sum((YY-matmul(XX,beta_T(:,t)))))+random_normal()*sqrt(R_g)

            DEALLOCATE(W);         DEALLOCATE(Y)
            DEALLOCATE(X);         DEALLOCATE(XX)      
            DEALLOCATE(S1);         DEALLOCATE(YY) 
            DEALLOCATE(zz_1) 
        END DO
        !$omp end parallel 



        !******** Calculate Log likelihood function value *********!

        Call OMP_SET_NUM_THREADS(Nthreads)
        !$omp parallel default(shared) private(g, NN,V, S1, Y,X, XX, W,&
        !$omp & psi_1, ep_1, ep_1v, INFO, CODE, DD1,  &
        !$omp & C, V1, zz_1, IPIV, INDX, det1, q_1,  &
        !$omp & pp, i, j, like_Y1, rand, &
        !$omp & ithread, iblock, ibegin, iend) 

        ithread = OMP_GET_THREAD_NUM()
        iblock = (GG+Nthreads-1)/Nthreads
        ibegin = ithread*iblock+1
        iend = min((ithread+1)*iblock,GG)

        DO g = ibegin,iend

            NN=N(g)
            ALLOCATE(V(NN,NN));        ALLOCATE(S1(NN,NN)); 
            ALLOCATE(Y(NN));  
            ALLOCATE(X(NN)) ;       ALLOCATE(XX(NN,2)) ;
            ALLOCATE(W(NN,NN)); 
            ALLOCATE(V1(NN,NN));
            ALLOCATE(psi_1(NN,NN)); 
            ALLOCATE(ep_1(NN));         
            ALLOCATE(ep_1v(NN));      
            ALLOCATE(C(NN,NN));       	
            ALLOCATE(zz_1(NN,DD));     
            ALLOCATE(IPIV(NN));        ALLOCATE(INDX(NN));    

            V=(sigma_T(1,t)-sum(sigma_T(2:DD+1,t)*sigma_T(2:DD+1,t)))*EYE(NN)
            W=W_raw(1:NN,1:NN,g)
            C=C_raw(1:NN,1:NN,g)
            Y=Y_raw(1:NN,g)
            X=X_raw(1:NN,g)
            zz_1=zz(1:NN,1:DD,g)
            XX(:,1)=X 
            XX(:,2)=matmul(W,X)

            pp=0.0
            DO i=1,NN
                DO j=1, NN
                    IF (j/=i) THEN
                        IF (DD==1) THEN
                            psi_1(i,j)=gamma_T(1,t)+gamma_T(2,t)*c(i,j)-gamma_T(3,t)*abs(zz_1(i,1)-zz_1(j,1))
                        ELSEIF (DD==2) THEN
                            psi_1(i,j)=gamma_T(1,t)+gamma_T(2,t)*c(i,j)-gamma_T(3,t)*abs(zz_1(i,1)-zz_1(j,1))-gamma_T(4,t)*abs(zz_1(i,2)-zz_1(j,2))
                        ELSEIF (DD==3) THEN
                            psi_1(i,j)=gamma_T(1,t)+gamma_T(2,t)*c(i,j)-gamma_T(3,t)*abs(zz_1(i,1)-zz_1(j,1))-gamma_T(4,t)*abs(zz_1(i,2)-zz_1(j,2)) &
                            & -gamma_T(5,t)*abs(zz_1(i,3)-zz_1(j,3)) 
                        ELSEIF (DD==4) THEN
                            psi_1(i,j)=gamma_T(1,t)+gamma_T(2,t)*c(i,j)-gamma_T(3,t)*abs(zz_1(i,1)-zz_1(j,1))-gamma_T(4,t)*abs(zz_1(i,2)-zz_1(j,2)) &
                            & -gamma_T(5,t)*abs(zz_1(i,3)-zz_1(j,3)) -gamma_T(6,t)*abs(zz_1(i,4)-zz_1(j,4))
                        ENDIF
                        q_1=(psi_1(i,j)*W(i,j))-log(1+exp(psi_1(i,j)))
                        pp=pp+q_1
                    ENDIF
                END DO 
            END DO

            S1=eye(NN)-lambda_T(t)*W

            ep_1=matmul(S1,Y)-matmul(XX,beta_T(:,t))-matmul(zz_1,sigma_T(2:DD+1,t))-alpha_T(g,t)
            ep_1v=ep_1

            V1=V
            CALL SGESV(NN,1,V1,NN,IPIV,ep_1v,NN,INFO)

            det1=FindDet(S1, NN)

            like_Y1=-0.5*NN*log(2*pi)-0.5*NN*log(sigma_T(1,t)-sum(sigma_T(2:DD+1,t)*sigma_T(2:DD+1,t)))+log(det1)-dot_product(ep_1, ep_1v)/2
            pp_G(g)=pp+like_Y1


            DEALLOCATE(V);        DEALLOCATE(S1); 
            DEALLOCATE(Y);  
            DEALLOCATE(X) ;       DEALLOCATE(XX) ;
            DEALLOCATE(W);  
            DEALLOCATE(V1);
            DEALLOCATE(psi_1); 
            DEALLOCATE(ep_1);         
            DEALLOCATE(ep_1v);      
            DEALLOCATE(C);      
            DEALLOCATE(zz_1);     
            DEALLOCATE(IPIV);     DEALLOCATE(INDX);  
        END DO
        !$omp end parallel   	

        logp_T(t)=sum(pp_G)

        call system_clock ( clock_stop, clock_rate, clock_max )
        t_round=t/100
        IF (t-t_round*100==0) THEN
            WRITE(*,*)   'T=', t 
            WRITE(*,'(a6, f7.4)') 'Time:', real ( clock_stop - clock_start ) / real ( clock_rate )        
            WRITE(*,'(a6,5f7.4)') 'GAMMA:', gamma_T(:,t)   
            WRITE(*,'(a6,f7.4)') 'LAMBDA:', lambda_T(t)       
            WRITE(*,'(a6,2f7.4)') 'BETA:', beta_T(1:2,t)
            WRITE(*,'(a6,5f7.4)') 'SIGMA:',  sigma_T(:,t)
            WRITE(*,'(a6,f10.2)') 'Likeli:',  logp_T(t)
            WRITE(*,'(a6,f10.2)') 'c_3:',  c_3(1)
        END IF 

    END DO

    Mean_lat=zz_mean

    RETURN
    END subroutine FULL_SCSAR




    END MODULE FULL_MCMC




