% ML_ndynfactors_Onatski - Runs, and shows results of the Onatski (2009, ECTA) test

% by Matteo Luciani (matteo.luciani@ulb.ac.be)

function Onatski=ML_ndynfactors_Onatski(y,S,qmax)

if nargin==2; qmax=7; end
T=size(y,1);
for k0=0:qmax; for k1=k0+1:qmax; onatski(k0+1,k1)=dynamico(y',k0,k1,2*pi/T,S'); end; end;  % Onatski (2009)
Onatski=[NaN 1:qmax;(0:qmax-1)' onatski]; 

disp('***************************************************');
disp('**                                               **');
disp('**   Determining the Number of Dynamic Factors   **');
disp('**                                               **');
disp('***************************************************');
disp('*** == Onatski (2009) Test for Number of Dynamic Factors == ***');
disp(Onatski);
disp('*** First Column = k0; First Row = k1; H0 = k0; h1 = k1 ***'); 