% ML_boostrap_BB - Produces Bootstrap Sample as in Black Box FGLR09
%
% xstar = ML_boostrap_BB(impulse, xsi, nblocks)
%   impulse - structural impulse response function
%   xsi - idiosyncratic component
%   nblocks - number of blocks
%

% Written by Matteo Luciani (matteo.luciani@ulb.ac.be)

function xstar = ML_boostrap_BB(impulse, xsi, nblocks,lambda,fhat,Ahat,u,det,n,R)

[T,N]=size(xsi); 
if nargin == 3;
    xsistar = boot_block(xsi, nblocks);                                     % Block Bootstrapping the idiosyncratic component
    t=size(xsistar,1); chistar = boot_chi(impulse,T,N,t);    
    xstar = sum(chistar(61:end,:,:),3) + xsistar;
elseif nargin == 4;
    chistar = fhat*lambda' + randn(size(chat));        
    xsistar = boot_block(xsi, nblocks,1);                                   % Block Bootstrapping the idiosyncratic component
    xstar = chistar + xsistar;
else
    xsistar = boot_block(xsi, nblocks,1);                                   % Block Bootstrapping the idiosyncratic component
    bootsam=ceil(n*rand(n,1));                                              % reshuffling residuals
    if nargin ~= 10; R=eye(size(u,2)); end;             
    fstar=ML_decomposition(fhat,Ahat,u(bootsam,:),det,R);                  % Simulated Factors    
    xstar = fstar*lambda' + xsistar;
end;


%%% =========================================================== %%%
%%% === Generates common components by using the structural === %%%
%%% === moving average representations + a N(0,1) shock     === %%%
%%% =========================================================== %%%

function chistar = boot_chi(impulse,T,N,t);
q=size(impulse,2);                                         % Miscellaneous 
shock = randn(t+60, q); % Normal Shocks necessary to generate the bootstrap common components
for jj=1:N; 
    for ii=1:q;
        chistar(:,jj,ii) = filter(squeeze(impulse(jj,ii,:)),1,shock(:,ii));
    end
end

%%% ==================================================== %%%
%%% === Block Bootstrap for Idiosyncratic Components === %%%
%%% ==================================================== %%%

function X_boot = boot_block(X,L,NN);
OPTS.disp=0;
[T,N] = size(X);
K = floor(T/L);                             % Lenght of a Block
blks = ceil(rand(K,1)*K); 
for i = 1:K
    X_boot(((i-1)*L+1):(i*L),:) = X(((blks(i)-1)*L+1):(blks(i)*L),:);
end

if nargin==3;
    if size(X_boot,1)<T;
        n=T-size(X_boot,1);
        bootsam=ceil((T-n)*rand);
        X_boot = [X_boot ; X(bootsam:bootsam+n-1,:)];
    end
end;