% ML_TimeLabel - Label a time indicator like 1999Q1
%

% Written by Matteo Luciani
% matteo.luciani@.ulb.ac.be

function TT=ML_TimeLabel(tt)
x=tt-floor(tt);                     % computes the decimal part of tt
for ii=1:max(size(tt));
    if     x(ii)==0;    TT(ii,:)=[num2str(floor(tt(ii))) 'Q1'];
    elseif x(ii)==0.25; TT(ii,:)=[num2str(floor(tt(ii))) 'Q2'];
    elseif x(ii)==0.50; TT(ii,:)=[num2str(floor(tt(ii))) 'Q3'];
    elseif x(ii)==0.75; TT(ii,:)=[num2str(floor(tt(ii))) 'Q4']; end;    
end;



