%% ML_SmokingGun_ReplicationFile4 - Reproduces Figures 6 & 7
% 
% Replication File for the paper 
% Monetary Policy and the Housing Market: A Structural Factor Analysis
% by Matteo Luciani (matteo.luciani@ulb.ac.be)
% ECARES Working Paper 2012-035 
% To appear on the Journal of Applied Econometrics
%

%% Upload Data and Define the Sample size %%
clear all; close all; clc
stampa=0;
ML_graph_options                                                            % Default Graphs Options
TR=1;                                                                       % Data transformation
out=1;                                                                      % Elimination of Outliers
[db, label,cd] = ML_SmokingGun_Data(TR,out);                                % Upload Data
name=ML_SmokingGunNames;                                                    % Name for variables
[DB]= ML_SmokingGun_Data(0,0); TT=1963:.25:2010.75;                         % Raw Data
T=size(db,1); t0=1963+.25*TR; tt=t0:0.25:t0+(T-1)*0.25;                     % useful objects
tb=find(tt==1982.5); te=find(tt==2008); tg=find(tt==2002.25);               % Extremes to truncate the sample
db(1:tb,:)=[];   [T N]=size(db); tt=tt(tb)+.25:0.25:tt(tb)+T*0.25;          % I consider only the second half of the sample

%% Setting-up Model Parameters %%
[y, My, Sy]=ML_Standardize(db);                                             % Standardize Data
yc=db-repmat(My,T,1);                                                       % Compute demeaned variables Useful for Historical Decomposition
r=7; p=1; q=4; s=21;                                                        % Parameter of the factor model
idvar=[31 35 55 56]; nv=size(idvar,2);                                      % Variables to be plotted

%% Estimating the Factor Model %%
[F, L, ~, rsh, ~, ~, SF] = ML_SmokingGun_efactorsML(db,q,r,p,100,3);        % ML Estimation of the DFM
chi=(F*L').*repmat(Sy,T,1)+repmat(My,T,1); xsi=(y-(F*L')).*repmat(Sy,T,1);  % The Common and the Idiosyncratic Component
share=var(chi)./var(db);

%% Uploading Data for Counterfactual Analysis %%
load taylor2; taylor=taylor2; clear taylor2;                                % load the FFR suggested by Taylor (1997)
zz=taylor(79+1:end);                                                        % Cut the observations prior to 1982
z=(zz-My(68))/Sy(68);                                                       % compute the standardized version
a=find(tt==2002);

%% Figure 6. Counterfactuals based on Conditional Forecasts: Taylor Conterfactual Exercise %%
yy0=y;  yy0(a+1:end,67:74)=NaN*ones(113-a,8);  yy0(:,68)=z;                 % What Happens if Taylor?
F0=ML_ConditionalForecasts(yy0,SF);                                         % Conditional Forecast of the Factors 
chi0=(F0*L').*repmat(Sy,113,1)+repmat(My,113,1);                            % Conditional Forecast of the Common Component

axes('Parent',figure,'FontSize',10); ML_FigureSize
for ii=1:4;
    subplot(2,2,ii); hold on
    area(tt(70:end),db(70:end,idvar(ii)),'linestyle','none', 'FaceColor', [0.7 0.7 0.7])               
    plot(tt(70:end),db(70:end,idvar(ii))+chi0(70:end,idvar(ii))-chi(70:end,idvar(ii)),'k','linewidth',1)
    hold off; title(name{idvar(ii)},'FontAngle','italic','fontsize',10); axis tight;
end

%% Figure 7. Counterfactuals based on Conditional Forecasts: Business cycle fluctuations and the federal funds rate %%
yy1=[y(1:a,:);NaN*ones(113-a,N)]; yy1(:,68)=y(:,68);                        % Conditional Forecast base on FFR only
F1=ML_ConditionalForecasts(yy1,SF);                                         % Conditional Forecast of the Factors 
chi1=(F1*L').*repmat(Sy,113,1)+repmat(My,113,1);                            % Conditional Forecast of the Common Component

axes('Parent',figure,'FontSize',10); ML_FigureSize
for ii=1:4;
    subplot(2,2,ii); hold on
    area(tt(70:end),db(70:end,idvar(ii)),'linestyle','none', 'FaceColor', [0.7 0.7 0.7])     
    plot(tt(70:end),db(70:end,idvar(ii))+chi1(70:end,idvar(ii))-chi(70:end,idvar(ii)),'k','linewidth',1)
    hold off; title(name{idvar(ii)},'FontAngle','italic','fontsize',10); axis tight;
end
