clear all

use agw9399.dta, clear

replace b7b=0 if b7b<0

* match missing variables from consequence years.
	** variables including year of birth, year of schooling and non-capital income
	*** prov regio sted famsize kids not included in this dataset

global matchvarlist "gebjaar scholing"
replace gebjaar=. if geslacht==0
replace scholing=. if scholing==0
foreach y of global matchvarlist{
by nomem nohhold, sort: egen `y'min=min(`y')
by nomem nohhold, sort: egen `y'max=max(`y')
}
replace gebjaar=gebjaarmax if gebjaar==. & gebjaarmin==gebjaarmax
gen age=year-gebjaar
replace scholing=scholingmax if scholing==. & scholingmin==scholingmax

gen edu=. if scholing==0
replace edu=0 if scholing==12|scholing==13
replace edu=1 if scholing==10
replace edu=2 if scholing==1|scholing==2
replace edu=3 if scholing==3|scholing==5
replace edu=4  if scholing==4
replace edu=5 if scholing==6|scholing==11
replace edu=6 if scholing==7|scholing==8
replace edu=7 if scholing==9

gen b1bpos=0
replace b1bpos=b1b if b1b>=0
gen b1bneg=0
replace b1bneg=-b1b if b1b<0

* aggregate asset and debt catagories
gen chesav=b1bpos+b3b+b5b
gen certidep=b4b+b6b
gen empsav=b2b
gen defcont=b7b
gen ins=b8b
gen otherfa=b24b+b25b
gen growth=b11b
gen bond=b13b
gen mutual=b12b
gen stock=b14b+b15b+b16b+b17b+b18b

* impute financial asset /real estate mortgage values
sort nomem nohhold year
global finanvarlist "btot chesav certidep empsav defcont ins otherfa growth bond mutual stock b19hyb b26hyb b27hyb b19ogb b26ogb b27ogb"
foreach y of global finanvarlist{
replace `y'=`y'[_n-1]/2+`y'[_n+1]/2 if nohhold==nohhold[_n-1] & nohhold==nohhold[_n+1] & `y'==. & `y'[_n-1]>0 &`y'[_n+1]>0 & `y'[_n-1]~=. &`y'[_n+1]~=.
replace `y'=`y'[_n-1]/2+`y'[_n+1]/2 if nohhold==nohhold[_n-1] & nohhold==nohhold[_n+1] & `y'==0 & `y'[_n-1]>0 &`y'[_n+1]>0 & `y'[_n-1]~=. &`y'[_n+1]~=.
}

gen house=b26ogb
gen otherre=b19ogb+b27ogb
gen dur=b20b+b21b+b22b+b23b

gen mort=b19hyb+b26hyb+b27hyb
gen conscre=s1b+s2b+s3b+s4b+s7b
gen studloan=s6b
gen cheover=b1bneg
gen otherdebt=s5b+s8b

* aggregate variables within families
gen income=btot
global aggvarlist "income chesav certidep empsav defcont ins otherfa growth bond mutual stock house otherre dur mort conscre studloan cheover otherdebt"
foreach y of global aggvarlist{
gen `y'flag=0
replace `y'flag=1 if `y'~=.
by nohhold year, sort: egen fam`y'flag=max(`y'flag)
by nohhold year, sort: egen fam`y'=sum(`y')
}

keep if famincomeflag==1
keep if famchesavflag==1
keep if famhouseflag==1
keep if edu~=.
keep if positie==1

drop b1b-s8b b26ogb-b27hyb b1bpos b1bneg
drop _merge _merge1 _merge2 _merge3 _merge4 _merge5
drop urb-woonsit chesav-income panel-bezigbel
foreach y of global matchvarlist{
drop `y'min `y'max
}

save agw9399hh.dta,replace

clear all

use agw0208.dta, clear

replace b7b=0 if b7b<0
replace b26hyb=. if b26hyb<0

* match missing variables from consequence years.
	** variables including year of birth, year of schooling and non-capital income
	*** regional variables such as prov regio sted and household structure variables such as family size, number of kids are not included for now

global matchvarlist "gebjaar oplzon"
foreach y of global matchvarlist{
by nomem nohhold, sort: egen `y'min=min(`y')
by nomem nohhold, sort: egen `y'max=max(`y')
}

replace gebjaar=gebjaarmax if gebjaar==. & gebjaarmin==gebjaarmax
gen age=year-gebjaar
replace oplzon=oplzonmax if oplzon==. & oplzonmin==oplzonmax

gen edu=oplzon
replace edu=0 if oplzon==8|oplzon==9

gen b1bpos=0
replace b1bpos=b1b if b1b>=0
gen b1bneg=0
replace b1bneg=-b1b if b1b<0

* aggregate asset and debt catagories
gen chesav=b1bpos+b3b
gen certidep=b4b+b6b
gen empsav=b2b
gen defcont=b7b
gen ins=b8b
gen otherfa=b24b+b25b
gen growth=b11b
gen bond=b13b
gen mutual=b12b
gen stock=b14b+b15b+b16b+b17b+b18b

* impute financial asset /real estate mortgage values
sort nomem nohhold year
global finanvarlist "btot chesav certidep empsav defcont ins otherfa growth bond mutual stock b19hyb b26hyb b27hyb b19ogb b26ogb b27ogb"
foreach y of global finanvarlist{
replace `y'=`y'[_n-1]/2+`y'[_n+1]/2 if nohhold==nohhold[_n-1] & nohhold==nohhold[_n+1] & `y'==. & `y'[_n-1]>0 &`y'[_n+1]>0 & `y'[_n-1]~=. &`y'[_n+1]~=.
replace `y'=`y'[_n-1]/2+`y'[_n+1]/2 if nohhold==nohhold[_n-1] & nohhold==nohhold[_n+1] & `y'==0 & `y'[_n-1]>0 &`y'[_n+1]>0 & `y'[_n-1]~=. &`y'[_n+1]~=.
}

gen house=b26ogb
gen otherre=b19ogb+b27ogb
gen dur=b20b+b21b+b22b+b23b

gen mort=b19hyb+b26hyb+b27hyb
gen conscre=s1b+s2b+s3b+s4b+s7b
gen studloan=s6b
gen cheover=b1bneg
gen otherdebt=s5b+s8b

* aggregate variables within families
gen income=btot
global aggvarlist "income chesav certidep empsav defcont ins otherfa growth bond mutual stock house otherre dur mort conscre studloan cheover otherdebt"
foreach y of global aggvarlist{
gen `y'flag=0
replace `y'flag=1 if `y'~=.
by nohhold year, sort: egen fam`y'flag=max(`y'flag)
by nohhold year, sort: egen fam`y'=sum(`y')
}

keep if famincomeflag==1
keep if famchesavflag==1
keep if famhouseflag==1
keep if edu~=.
keep if positie==1

* drop redundant variables
drop b1b-s8b b26ogb-b27hyb b1bpos b1bneg
drop b11b-bezigbel chesav-income
drop _merge _merge1 _merge2 _merge3 _merge4 
foreach y of global matchvarlist{
drop `y'min `y'max
}


save agw0208hh.dta,replace

append using agw9399hh.dta
drop btot-regio woonvorm-burgst 
 
* generate aggregated variables 
gen famsafe1=famchesav+famcertidep
gen famsafe2=famempsav+famdefcont+famins+famgrowth+famotherfa
gen famsafe=famsafe1+famsafe2
gen famrisky=fambond+famstock+fammutual
gen famfa=famsafe+famrisky
gen famnfa=famhouse+famotherre+famdur
gen famdebt=fammort+famconscre+famstudloan+famcheover+famotherdebt
gen famasset=famfa+famnfa
gen famtw=famasset-famdebt
drop if famtw==.

drop if famfa==0
drop if famtw<=0
gen lfamfa=log(famfa)
gen lfamtw=log(famtw)
gen lfamnoncapinc=log(famincome)
replace lfamnoncapinc=0 if famincome==0
gen sharesafe=famsafe1/famfa

keep if age>=41 & age<=79

* form 3y+ panel
gen ones=1
sort nohhold year
by nohhold, sort: egen timeperiod=sum(ones)
keep if timeperiod>=3

gen edu_sec=0
replace edu_sec=1 if edu==3|edu==4
gen edu_voc=0
replace edu_voc=1 if edu==5
gen edu_voccol=0
replace edu_voccol=1 if edu==6
gen edu_univ=0
replace edu_univ=1 if edu==7

rename nohhold id
sort id year 

by id, sort: egen lfamfa_bar=mean(lfamfa)
by id, sort: egen lfamtw_bar=mean(lfamtw)
by id, sort: egen lfamnoncapinc_bar=mean(lfamnoncapinc)

gen t=year-1992

* add market information
gen aexreturn=1.4003 if year==1993
gen interest=1.0707 if year==1993
gen dispersion=1.0690 if year==1993

replace aexreturn=1.0668 if year==1994
replace interest=1.0514 if year==1994
replace dispersion=0.2480 if year==1994

replace aexreturn=1.1139 if year==1995
replace interest=1.0423 if year==1995
replace dispersion=0.6177 if year==1995

replace aexreturn=1.3078 if year==1996
replace interest=1.0288 if year==1996
replace dispersion=1.2780 if year==1996

replace aexreturn=1.4787 if year==1997
replace interest=1.0307 if year==1997
replace dispersion=8.4677 if year==1997

replace aexreturn=1.1554 if year==1998
replace interest=1.0321 if year==1998
replace dispersion=8.0429 if year==1998

replace aexreturn=1.0776 if year==1999
replace interest=1.0274 if year==1999
replace dispersion=4.7193 if year==1999

replace aexreturn=0.7172 if year==2002
replace interest=1.0329 if year==2002
replace dispersion=11.6154 if year==2002

replace aexreturn=0.9738 if year==2003
replace interest=1.0232 if year==2003
replace dispersion=2.4569 if year==2003

replace aexreturn=1.0008 if year==2004
replace interest=1.0205 if year==2004
replace dispersion=0.4281 if year==2004

replace aexreturn=1.1678 if year==2005
replace interest=1.0209 if year==2005
replace dispersion=1.0824 if year==2005

replace aexreturn=1.2696 if year==2006
replace interest=1.0283 if year==2006
replace dispersion=1.1671 if year==2006

replace aexreturn=1.0965 if year==2007
replace interest=1.0385 if year==2007
replace dispersion=1.1755 if year==2007

replace aexreturn=0.4983 if year==2008
replace interest=1.0483 if year==2008
replace dispersion=9.4113 if year==2008

keep id age lfamfa lfamtw lfamnoncapinc sharesafe edu_voc edu_voccol edu_univ lfamfa_bar lfamtw_bar lfamnoncapinc_bar t aexreturn interest dispersion 

save cleaneddata.dta,replace

set more on
