function s = ape_app_crs(f1,x,varargin) % ape code for the empirical section. 

eps = 1e-10;
n1 = size(x,2);
z=varargin{4};s_bar=varargin{5};
sbar_ind=varargin{6};varargin(6)=[];varargin(5)=[];
[obs q]=size(z);
h = eps.^(1/3)*max(min(abs([x z]),[],1),1e-2)';
n2=n1+q;
ee = sparse(1:n2,1:n2,h,n2,n2);
pe = zeros(obs,n2-1+3);
varargin2=varargin;
NT=size(x,1);
N=size(sbar_ind,1);
for j=1:N
    % Compute expected response values for continuous x varibles
    ssbar=[s_bar(:,1:4) ones(NT,1)*sbar_ind(j,:)];
    xz=kron(z,ones(1,size(ssbar,2))).*kron(ones(1,q),ssbar);
    xx=[x xz];
    fx1 = feval(f1,xx,varargin{:});
    for i=1:6
        % Compute forward step for continuous x variables
        xplus=x+ones(obs,1)*ee(i,1:n1);
        xxplus=[xplus xz];
        pe(:,i) = pe(:,i)+(feval(f1,xxplus,varargin{:})-fx1)/h(i)/N;
        xplus=[];xxplus=[];
    end
    % Compute expected response values for age dummies
    z_d=z;
    z_d(:,2:end)=zeros(obs,6);
    varargin2{4}=z_d;
    xz_d=kron(z_d,ones(1,size(ssbar,2))).*kron(ones(1,q),ssbar);
    xx_d=[x xz_d];
    fx1_d = feval(f1,xx_d,varargin2{:});
    for i=7:12
        % Compute forward step for age dummies
        zplus=z_d;zplus(:,i-n1+1)=ones(obs,1);
        varargin2{4}=zplus;
        xzplus=kron(zplus,ones(1,size(ssbar,2))).*kron(ones(1,q),ssbar);
        xxplus=[x xzplus];
        pe(:,i) = pe(:,i)+(feval(f1,xxplus,varargin2{:})-fx1_d)/N;
    end
    % Compute expected response values for education dummies
    z_d=[];xz_d=[];xx_d=[];fx1_d=[];fx2_d=[];
    ssbar_j=[1 0 0 0 sbar_ind(j,:)];
    xz_d=kron(z,ssbar_j);
    xx_d=[x xz_d];
    fx1_d = feval(f1,xx_d,varargin{:});
    for i=13:15
        % Compute forward step for education dummies
        ssbar_j_forward=ssbar_j;ssbar_j_forward(i-n2+2)=1;
        xzplus=kron(z,ssbar_j_forward);
        xxplus=[x xzplus];
        pe(:,i) = pe(:,i)+(feval(f1,xxplus,varargin{:})-fx1_d)/N;
    end
end
 temp=pe;pe(:,7:end)=temp(:,4:end-3);pe(:,4:6)=temp(:,end-2:end);
 s.pe=pe;