clear all;
load data;
name='app_clad';

% name variables
id=data(:,1);
age=data(:,2);  
lfamfa=data(:,3);
lfamtw=data(:,4);
lfamnoncapinc=data(:,5);
sharesafe=data(:,6);
edu_voc=data(:,7);
edu_voccol=data(:,8);
edu_univ=data(:,9);
lfamfa_bar=data(:,10);
lfamtw_bar=data(:,11);
lfamnoncapinc_bar=data(:,12);
t=data(:,13);
aexreturn=data(:,14);
interest=data(:,15);
var2mean=data(:,16);
data=[];

NT=length(sharesafe);
age1=zeros(NT,1);
age1(age>45&age<=50)=1;
age2=zeros(NT,1);
age2(age>50&age<=55)=1;
age3=zeros(NT,1);
age3(age>55&age<=60)=1;
age4=zeros(NT,1);
age4(age>60&age<=65)=1;
age5=zeros(NT,1);
age5(age>65&age<=70)=1;
age6=zeros(NT,1);
age6(age>70)=1;
age=[];

j=[];
for i=2:NT
    if id(i)~=id(i-1)
        j=[j;i];
     end
end
N=length(j)+1;
vec(1,1)=j(1,1)-1;
for i=2:N-1
    vec(i,1)=j(i,1)-j(i-1,1);
end
vec(N,1)=NT-j(N-1,1)+1;

cons=ones(NT,1);
y=sharesafe; sharesafe=[];
premium=aexreturn-interest;
aexreturn=[];interest=[];
B=1000;

toler=sqrt(eps);
%% CLAD estimates, pooled
x=[lfamfa lfamtw lfamnoncapinc edu_voc edu_univ edu_voccol premium var2mean t age1 age2 age3 age4 age5 age6];
z=cons;
s_bar=cons;
d_p=size(x,2);q_p=size(z,2);p_p=size(s_bar,2);
beta0_p=ones(d_p+p_p*q_p,1)*0.005;
beta_p=ipqr(0.5,d_p+p_p*q_p,y,[x kron(z,ones(1,p_p)).*kron(ones(1,q_p),s_bar)],'myclad',toler,beta0_p);

%% CLAD estimates, cre
x=[lfamfa lfamtw lfamnoncapinc edu_voc edu_univ edu_voccol premium var2mean t age1 age2 age3 age4 age5 age6 cons];
z=cons;
s_bar=[lfamfa_bar lfamtw_bar lfamnoncapinc_bar];
d_cre=size(x,2);q_cre=size(z,2);p_cre=size(s_bar,2);
beta0_cre=ones(d_cre+p_cre*q_cre,1)*0.005;
beta_cre=ipqr(0.5,d_cre+p_cre*q_cre,y,[x kron(z,ones(1,p_cre)).*kron(ones(1,q_cre),s_bar)],'myclad',toler,beta0_cre);

%% CLAD estimates, crs
x=[lfamfa lfamtw lfamnoncapinc premium var2mean t];
z=[cons age1 age2 age3 age4 age5 age6];
s_bar=[cons edu_voc edu_univ edu_voccol lfamfa_bar lfamtw_bar lfamnoncapinc_bar];
d_crs=size(x,2);q_crs=size(z,2);p_crs=size(s_bar,2);
beta0_crs=ones(d_crs+p_crs*q_crs,1)*0.005;
beta_crs=ipqr(0.5,d_crs+p_crs*q_crs,y,[x kron(z,ones(1,p_crs)).*kron(ones(1,q_crs),s_bar)],'myclad',toler,beta0_crs);

% bootstrap standard errors
bsdata=[id y cons lfamfa lfamtw lfamnoncapinc edu_voc edu_univ edu_voccol premium var2mean t age1 age2 age3 age4 age5 age6 lfamfa_bar lfamtw_bar lfamnoncapinc_bar]; 
bsdata_sub=mat2cell(bsdata,vec,size(bsdata,2));
bsdata=[];
clear x z s_bar id y cons lfamfa lfamtw lfamnoncapinc edu_voc edu_univ edu_voccol premium var2mean t age1 age2 age3 age4 age5 age6 lfamfa_bar lfamtw_bar lfamnoncapinc_bar; 

rng('default')
info.inference=0;
for b=1:B
    rd_idx=round(0.5+N*rand(N,1));
    data_bs=[];vec_bs=[];
    for i=1:N
        data_bs=[data_bs;bsdata_sub{rd_idx(i)}];
        vec_bs=[vec_bs;size(bsdata_sub{rd_idx(i)},1)];
    end
    y_bs=data_bs(:,2);
    % p
    x_bs=data_bs(:,4:3+d_p);
    z_bs=data_bs(:,3);
    s_bar_bs=data_bs(:,3);
    beta_p_bs(:,b)=ipqr(0.5,d_p+p_p*q_p,y_bs,[x_bs kron(z_bs,ones(1,p_p)).*kron(ones(1,q_p),s_bar_bs)],'myclad',toler,beta_p);

    % cre
    x_bs=[data_bs(:,4:3+d_cre-1) data_bs(:,3)];     
    z_bs=data_bs(:,3);
    s_bar_bs=data_bs(:,3+d_cre:3+d_cre+p_cre-1); 
    beta_cre_bs(:,b)=ipqr(0.5,d_cre+p_cre*q_cre,y_bs,[x_bs kron(z_bs,ones(1,p_cre)).*kron(ones(1,q_cre),s_bar_bs)],'myclad',toler,beta_cre);

    % crs
    x_bs=data_bs(:,4:3+d_crs+3);
    z_bs=[data_bs(:,3) data_bs(:,4+d_crs+3:3+d_crs+3+(q_crs-1))];
    s_bar_bs=[data_bs(:,3) data_bs(:,3+d_cre:3+d_cre+(p_cre-1))];
    s_bar_bs(:,2+3:end+3)=s_bar_bs(:,2:end);
    s_bar_bs(:,2:1+3)=x_bs(:,4:3+3);
    x_bs(:,4:3+3)=[];
    beta_crs_bs(:,b)=ipqr(0.5,d_crs+p_crs*q_crs,y_bs,[x_bs kron(z_bs,ones(1,p_crs)).*kron(ones(1,q_crs),s_bar_bs)],'myclad',toler,beta_crs);
    clear y_bs x_bs z_bs s_bar_bs 
    
    if b/100==round(b/100)
    b    
    save(name)
    betastd_p=std(beta_p_bs,0,2);
    betastd_cre=std(beta_cre_bs,0,2);
    betastd_crs=std(beta_crs_bs,0,2);

    disp('b: p -- cre -- rs')
    for k=1:3
        disp(['  &  '  num2str(beta_p(k,:),'%0.4f') '  &  ' num2str(beta_cre(k,:),'%0.4f') '  &  ' num2str(beta_crs(k,:),'%0.4f') ] )
        disp(['  &  ('  num2str(betastd_p(k,:),'%0.4f') ')  &  (' num2str(betastd_cre(k,:),'%0.4f') ')  &  (' num2str(betastd_crs(k,:),'%0.4f') ')'] )
        disp(['  &  '  num2str(beta_p(k,:)/betastd_p(k,:),'%0.4f') '  &  ' num2str(beta_cre(k,:)/betastd_cre(k,:),'%0.4f') '  &  ' num2str(beta_crs(k,:)/betastd_crs(k,:),'%0.4f') ] )
    end
    for k=4:6
        disp(['  &  '  num2str(beta_p(k,:),'%0.4f')  '  &  ' num2str(beta_cre(k,:),'%0.4f') '  &  ' num2str(beta_crs(end-6+(k-3),:),'%0.4f')  ] )
        disp(['  &  ('  num2str(betastd_p(k,:),'%0.4f')  ')  &  (' num2str(betastd_cre(k,:),'%0.4f') ')  &  (' num2str(betastd_crs(end-6+(k-3),:),'%0.4f') ')' ] )
        disp(['  &  '  num2str(beta_p(k,:)/betastd_p(k,:),'%0.4f') '  &  ' num2str(beta_cre(k,:)/betastd_cre(k,:),'%0.4f') '  &  ' num2str(beta_crs(end-6+(k-3),:)/betastd_crs(end-6+(k-3),:),'%0.4f') ] )
   end
    for k=7:9
        disp(['  &  '  num2str(beta_p(k,:),'%0.4f')  '  &  ' num2str(beta_cre(k,:),'%0.4f') '  &  '  num2str(beta_crs(k-3,:),'%0.4f') ] )
        disp(['  &  ('  num2str(betastd_p(k,:),'%0.4f')  ')  &  (' num2str(betastd_cre(k,:),'%0.4f') ')  &  ('  num2str(betastd_crs(k-3,:),'%0.4f') ')'] )
        disp(['  &  '  num2str(beta_p(k,:)/betastd_p(k,:),'%0.4f') '  &  ' num2str(beta_cre(k,:)/betastd_cre(k,:),'%0.4f') '  &  ' num2str(beta_crs(k-3,:)/betastd_crs(k-3,:),'%0.4f') ] )
   end
    for k=10:16
        disp(['  &  '  num2str(beta_p(k,:),'%0.4f') '  &  ' num2str(beta_cre(k,:),'%0.4f') '  &  '   ] )
        disp(['  &  ('  num2str(betastd_p(k,:),'%0.4f') ')  &  (' num2str(betastd_cre(k,:),'%0.4f') ')  &  ' ] )
        disp(['  &  '  num2str(beta_p(k,:)/betastd_p(k,:),'%0.4f') '  &  ' num2str(beta_cre(k,:)/betastd_cre(k,:),'%0.4f') '  &  '] )
    end
    disp('------------------------------------------------------------')
    for k=1:p_crs
        disp([' &  ' num2str(beta_crs(d_crs+k,:),'%0.4f') ' &  ' num2str(beta_crs(d_crs+p_crs+k,:),'%0.4f') ' &  ' num2str(beta_crs(d_crs+2*p_crs+k,:),'%0.4f') ' &  ' num2str(beta_crs(d_crs+3*p_crs+k,:),'%0.4f') ' &  ' num2str(beta_crs(d_crs+4*p_crs+k,:),'%0.4f') ' &  ' num2str(beta_crs(d_crs+5*p_crs+k,:),'%0.4f') ' &  '  num2str(beta_crs(d_crs+6*p_crs+k,:),'%0.4f') ])
        disp([' &  (' num2str(betastd_crs(d_crs+k,:),'%0.4f') ')  &  (' num2str(betastd_crs(d_crs+p_crs+k,:),'%0.4f') ')  &  (' num2str(betastd_crs(d_crs+2*p_crs+k,:),'%0.4f') ')  &  (' num2str(betastd_crs(d_crs+3*p_crs+k,:),'%0.4f') ')  &  (' num2str(betastd_crs(d_crs+4*p_crs+k,:),'%0.4f') ')  &  (' num2str(betastd_crs(d_crs+5*p_crs+k,:),'%0.4f') ')  &  ('  num2str(betastd_crs(d_crs+6*p_crs+k,:),'%0.4f') ')' ])
        disp([' &  ' num2str(beta_crs(d_crs+k,:)/betastd_crs(d_crs+k,:),'%0.4f') '  &  ' num2str(beta_crs(d_crs+p_crs+k,:)/betastd_crs(d_crs+p_crs+k,:),'%0.4f') '  &  ' num2str(beta_crs(d_crs+2*p_crs+k,:)/betastd_crs(d_crs+2*p_crs+k,:),'%0.4f') '  &  ' num2str(beta_crs(d_crs+3*p_crs+k,:)/betastd_crs(d_crs+3*p_crs+k,:),'%0.4f') '  &  ' num2str(beta_crs(d_crs+4*p_crs+k,:)/betastd_crs(d_crs+4*p_crs+k,:),'%0.4f') '  &  ' num2str(beta_crs(d_crs+5*p_crs+k,:)/betastd_crs(d_crs+5*p_crs+k,:),'%0.4f') '  &  '  num2str(beta_crs(d_crs+6*p_crs+k,:)/betastd_crs(d_crs+6*p_crs+k,:),'%0.4f')  ])
    end    
    end
end

