function [logl_proc,K_SS,ksaismo,yvar_SS]=ss_smooth(estim);

%This function will return the value of the observed log likelihood 
%the smoothed state %vecotr, the steady state kalman gain and 
%the steady state velue of the one step ahead forecast covariance matrix

global omega missing mycols sample F x hours approphour P10 P y

ksai10=zeros(mycols,1);              
ksai=zeros(sample,mycols);           
yvar=zeros(sample,1);                
v=zeros(sample,1);         
ksaismo=zeros(sample,mycols);       
K=zeros(sample,mycols);     
LL=F;

Q_PROC=zeros(hours,hours);
Q_PROC=diag(estim(1:hours),0);
Q_PROC2=zeros(mycols,mycols);

A_PROC=estim(hours+1:hours+1+hours*size(x,2)-1,:);
A_PROC=reshape(A_PROC,hours,size(x,2));

H_PROC=estim(hours+hours*size(x,2)+1:size(estim,1),:);
H_PROC=reshape(H_PROC',mycols,hours)';


P10=eye(mycols);
ii=hours*ceil(mycols/hours);
for jj=1:mycols
  P10(jj,jj)=Q_PROC(approphour(ii),approphour(ii));
ii=ii-1;
end;
%**************************************************************************
%Kalman Filter
%**************************************************************************
ksai10=zeros(mycols,1);
logl_proc=0;
for t=1:sample
    l=approphour(t);
    Q_PROC2(1,1)=Q_PROC(l,l);
    P10=F*P10*LL'+Q_PROC2;                
    v(t)=y(t)-H_PROC(l,:)*ksai10-A_PROC(l,:)*x(t,:)';
    yvar(t)=H_PROC(l,:)*P10*H_PROC(l,:)'+omega(l,l);
    K(t,:)=(F*P10*H_PROC(l,:)'*inv(yvar(t)))';
     if missing(t)==1;
        v(t)=0; K(t,:)=zeros(1,mycols);
    end
    if missing(t)==0
       logl_proc=logl_proc-(1/2)*log(det(yvar(t)))-(1/2)*(v(t)'*inv(yvar(t))*v(t));            
   end
    LL=F-K(t,:)'*H_PROC(l,:);
    ksai(t,:)=ksai10';    
    ksai10=F*ksai10+K(t,:)'*v(t);
    P(t,:)=symmat2vec(P10)';    
end
%**************************************************************************
%Fixed Interval Smoother
%**************************************************************************
N=zeros(mycols,mycols);
r=zeros(1,mycols);
for t=sample:-1:1
   l=approphour(t);
   LL=F-K(t,:)'*H_PROC(l,:);
   if missing(t)==1
      N=LL'*N*LL;
      r=(LL'*r')';
   end
   if missing(t)==0
      N=(H_PROC(l,:)'*inv(yvar(t))*H_PROC(l,:)+LL'*N*LL);
      r=(H_PROC(l,:)'*inv(yvar(t))*v(t)+LL'*r')';
   end
   Q_PROC2(1,1)=Q_PROC(l,l);
   P10=vec2symmat(P(t,:)');
   ksaismo(t,:)=(ksai(t,:)'+P10*r')';
   psmo2=(P10-P10*N*P10);
   P(t,:)=symmat2vec(psmo2)';
end
%save the steady state values
K_SS=K(sample-hours+1:sample,:);
yvar_SS=yvar(sample-hours+1:sample,:);
%**************************************************************************


 
