function [K_SS,yvar_SS]=ss_smooth(estim);

% the function will return the the steady state kalman gain 
% and the steady state velue of the one step ahead forecast 
% covariance matrix

global omega missing mycols sample F x hours approphour P10 P y

ksai10=zeros(mycols,1);              
ksai=zeros(sample,mycols);           
yvar=zeros(sample,1);                
v=zeros(sample,1);         
ksaismo=zeros(sample,mycols);       
K=zeros(sample,mycols);     
LL=F;

Q_PROC=zeros(hours,hours);
Q_PROC=diag(estim(1:hours),0);
Q_PROC2=zeros(mycols,mycols);

A_PROC=estim(hours+1:hours+1+hours*size(x,2)-1,:);
A_PROC=reshape(A_PROC,hours,size(x,2));

H_PROC=estim(hours+hours*size(x,2)+1:size(estim,1),:);
H_PROC=reshape(H_PROC',mycols,hours)';


P10=eye(mycols);
ii=hours*ceil(mycols/hours);
for jj=1:mycols
  P10(jj,jj)=Q_PROC(approphour(ii),approphour(ii));
ii=ii-1;
end;
%**************************************************************************
%Kalman Filter
%**************************************************************************
ksai10=zeros(mycols,1);
logl_proc=0;
for t=1:sample
    l=approphour(t);
    Q_PROC2(1,1)=Q_PROC(l,l);
    P10=F*P10*LL'+Q_PROC2;                
    v(t)=y(t)-H_PROC(l,:)*ksai10-A_PROC(l,:)*x(t,:)';
    yvar(t)=H_PROC(l,:)*P10*H_PROC(l,:)'+omega(l,l);
    K(t,:)=(F*P10*H_PROC(l,:)'*inv(yvar(t)))';
    LL=F-K(t,:)'*H_PROC(l,:);
    ksai(t,:)=ksai10';    
    ksai10=F*ksai10+K(t,:)'*v(t);
    P(t,:)=symmat2vec(P10)';    
end
%save the steady state values
K_SS=K(sample-hours+1:sample,:);
yvar_SS=yvar(sample-hours+1:sample,:);
%**************************************************************************


 
