function f=serrs(estim,ksaismo2)
%The function will resturn std.erros using the method discussed
% in Meilijson 1989, Journal of the Royal Statistical Society, Series B

global P y hours approphour_non sample...    
    approphour omega x non_missing appropj mycols appropj

Q=zeros(hours,hours);
Q=diag(estim(1:hours),0);

A=estim(hours+1:hours+1+hours*size(x,2)-1,:);
A=reshape(A,hours,size(x,2));

H=estim(hours+hours*size(x,2)+1:size(estim,1),:);
H=reshape(H',mycols,hours)';

grad_Q=zeros(sample,1);
grad_A=zeros(sample,size(A,2));
grad_H=zeros(sample,size(H,2)-1);
serrs_A=zeros(size(A,1),size(A,2));
serrs_H=zeros(size(H,1),size(H,2));
serrs_Q=zeros(size(Q,1),1);

for t=1:1:sample  
   l=approphour(t);
   j=appropj(l);
   omega2=omega(l,l);
   psmo_tmp1=vec2symmat(P(t,:)');
   psmo_tmp2=psmo_tmp1(2:j,2:j);
 
    grad_H(t,1:j-1)=((1/omega2)*...
                   ( (y(t)-ksaismo2(t,1))*ksaismo2(t,2:j)'-psmo_tmp1(2:j,1)...
                   -ksaismo2(t,2:j)'*A(l,:)*x(t,:)'...
                  -(ksaismo2(t,2:j)'*ksaismo2(t,2:j)+psmo_tmp2)*H(l,2:j)'))';   
   grad_A(t,:)= ((1/omega2)*...
               ((y(t)-ksaismo2(t,1))*x(t,:)'...
                    -x(t,:)'*H(l,2:j)*ksaismo2(t,2:j)'...
                    -x(t,:)'*x(t,:)*A(l,:)'))';                 
  sigma2=Q(l,l);
  grad_Q(t)= -(1/2)*(1/sigma2)+(1/2)*(1/sigma2^2)*(ksaismo2(t,1)^2+P(t,1));                        
end

l=1; ll=1;

grad_Q_non=grad_Q(non_missing==1,:);
grad_A_non=grad_A(non_missing==1,:);
grad_H_non=grad_H(non_missing==1,:);


for l=1:hours
    j=appropj(l);
    ind=approphour_non==l;
    grad_H2=grad_H_non(ind==1,1:j-1);
    grad_Q2=grad_Q_non(ind==1,:);
    grad_A2=grad_A_non(ind==1,:);

    grad_all=[grad_Q2 grad_A2 grad_H2];    
    
    serrs=zeros(size(grad_all,2),size(grad_all,2));
    
    t=1;
    for t=1:size(grad_all,1);
        serrs=serrs+grad_all(t,:)'*grad_all(t,:);
    end
    serrs=sqrt(diag(inv(serrs)));
    serrs_Q(l)=serrs(1);
    serrs_A(l,:)=serrs(2:2+size(x,2)-1)';
    serrs_H(l,1:j)=[0; serrs(2+size(x,2):size(serrs,1))]';
end

f=[serrs_Q serrs_A];