*******************************************************************************
* "ASSESSING THE PERFORMANCE OF MATCHING ALGORITHMS WHEN ... "                *
* Stata Do-File: spec04.do                                                    *
* Data version: PRESPEC.DTA                                                   *
*******************************************************************************

* Generate the data sets for the Gauss File preXX.g

* Estimation of the propensity score
* and of the linear index Xbetahat

* College droputs (collout) are excluded for both {t==0} and {t==1} because
* it seems that individuals with more college education but no further degree
* are different from no college-dropouts, in particular, they earn higher wages.


*******************************************************************************
* Using NLSY data
*******************************************************************************

* use D:\nlsy\prespec.dta


*******************************************************************************
* Keep only necessary variables and observations
*******************************************************************************

keep id t age79 degree grades yrhs yrdeg2 collout asparcom asworkno asmatkno asarirea asgensci asautsho asnumope aselcinf asmeccom ascodspe asacadem asnonaca afqt white black hisp female pboth occfemh occmalh gradmoth gradfath gedhs chinum18 bornsou urban14 urban18 workm14 mag14 newsp14 lib14 sibl siblgra deadfat marr18 nevfat18 biofat6 nonpar18 charag18 schpriv hsmath1 hsocc1 expsusp drug18 curr_voc curr_com curr_col curr_gen wage79-wage95 exps79 exp79 exps80 exp80 exps81 exp81 exps82 exp82 exps83 exp83 exps84 exp84 exps85 exp85 exps86 exp86 exps87 exp87 exps88 exp88 exps89 exp89 exps90 exp90 exps91 exp91 exps92 exp92 exps93 exp93 exps94 exp94 exps95 exp95 cexpm79-cexpm95 cexpsm79-cexpsm95 weigh79

drop if collout==1
drop if gedhs==0 & degree<2

* Dropping if there is no info about yrdeg2
drop if yrdeg2==. | yrdeg2>=94

drop gedhs


*******************************************************************************
* Treatment indicators other than BA
*******************************************************************************

* Indicator for AA
g ta=0 if t==0
replace ta=1 if degree==2

* Indicator for MA
g tm=0 if t==0
replace tm=1 if degree>=5


*******************************************************************************
* Aggregation of variables
*******************************************************************************

g curr_vc = curr_voc + curr_com
drop curr_voc curr_com
label var curr_vc "HS curriculum voc. or comm."

* The following variables are generated such that there are only few missing
* observations.

g       gradpar = .5*(gradfath+gradmoth) if gradfath!=. & gradmoth!=.
replace gradpar = gradfath               if gradfath!=. & gradmoth==.
replace gradpar = gradmoth               if gradfath==. & gradmoth!=.

g       libmag = lib14+mag14 if lib14!=. & mag14!=.
replace libmag = lib14+.5  if lib14!=. & mag14==.
replace libmag = mag14+.5  if lib14==. & mag14!=.

g       occparh = .5*(occmalh+occfemh) if occmalh!=. & occfemh!=.
replace occparh = occmalh if occmalh!=. & occfemh==.
replace occparh = occfemh if occmalh==. & occfemh!=.

program define miss
local i = 79
while `i'<96 {replace wage`i' = -1 if wage`i'==.
              local i = `i'+1}
end
miss
program drop miss


*******************************************************************************
* Probit estimation --> propensity scores
*******************************************************************************

* Broad specification, men, BA
probit t black hisp asmatkno asautsho schpriv expsusp curr_col curr_gen gradpar occparh sibl bornsou if t!=. & fem==0 & yrhs<90
predict p_bmb if t!=. & fem==0 & yrhs<90
predict ind_bmb if t!=. & fem==0 & yrhs<90, index
outfile id t p_bmb ind_bmb weigh79 black hisp age79 yrhs yrdeg2 wage79-wage95 exp79 exp80 exp81 exp82 exp83 exp84 exp85 exp86 exp87 exp88 exp89 exp90 exp91 exp92 exp93 exp94 exp95 exps79 exps80 exps81 exps82 exps83 exps84 exps85 exps86 exps87 exps88 exps89 exps90 exps91 exps92 exps93 exps94 exps95 cexpm79-cexpm95 cexpsm79-cexpsm95 asmatkno asautsho schpriv expsusp curr_col curr_gen gradpar occparh sibl bornsou using D:\matching extremes\stata\data\bmb.asc if p_bmb!=., nolabel

* Broad specification, women, BA
probit t black hisp asmatkno asautsho schpriv expsusp curr_col curr_gen gradpar occparh sibl bornsou if t!=. & fem==1 & yrhs<90
predict p_bwb if t!=. & fem==1 & yrhs<90
predict ind_bwb if t!=. & fem==1 & yrhs<90, index
outfile id t p_bwb ind_bwb weigh79 black hisp age79 yrhs yrdeg2 wage79-wage95 exp79 exp80 exp81 exp82 exp83 exp84 exp85 exp86 exp87 exp88 exp89 exp90 exp91 exp92 exp93 exp94 exp95 exps79 exps80 exps81 exps82 exps83 exps84 exps85 exps86 exps87 exps88 exps89 exps90 exps91 exps92 exps93 exps94 exps95 cexpm79-cexpm95 cexpsm79-cexpsm95 asmatkno asautsho schpriv expsusp curr_col curr_gen gradpar occparh sibl bornsou using D:\matching extremes\stata\data\bwb.asc if p_bwb!=., nolabel

* Broad specification, men, AA
probit ta black hisp asmatkno asautsho schpriv expsusp curr_col curr_gen gradpar occparh sibl bornsou if ta!=. & fem==0 & yrhs<93
predict p_bma if ta!=. & fem==0 & yrhs<93
predict ind_bma if ta!=. & fem==0 & yrhs<93, index
outfile id ta p_bma ind_bma weigh79 black hisp age79 yrhs yrdeg2 wage79-wage95 exp79 exp80 exp81 exp82 exp83 exp84 exp85 exp86 exp87 exp88 exp89 exp90 exp91 exp92 exp93 exp94 exp95 exps79 exps80 exps81 exps82 exps83 exps84 exps85 exps86 exps87 exps88 exps89 exps90 exps91 exps92 exps93 exps94 exps95 cexpm79-cexpm95 cexpsm79-cexpsm95 asmatkno asautsho schpriv expsusp curr_col curr_gen gradpar occparh sibl bornsou using D:\matching extremes\stata\data\bma.asc if p_bma!=., nolabel

* Broad specification, women, AA
probit ta black hisp asmatkno asautsho schpriv expsusp curr_col curr_gen gradpar occparh sibl bornsou if ta!=. & fem==1 & yrhs<93
predict p_bwa if ta!=. & fem==1 & yrhs<93
predict ind_bwa if ta!=. & fem==1 & yrhs<93, index
outfile id ta p_bwa ind_bwa weigh79 black hisp age79 yrhs yrdeg2 wage79-wage95 exp79 exp80 exp81 exp82 exp83 exp84 exp85 exp86 exp87 exp88 exp89 exp90 exp91 exp92 exp93 exp94 exp95 exps79 exps80 exps81 exps82 exps83 exps84 exps85 exps86 exps87 exps88 exps89 exps90 exps91 exps92 exps93 exps94 exps95 cexpm79-cexpm95 cexpsm79-cexpsm95 asmatkno asautsho schpriv expsusp curr_col curr_gen gradpar occparh sibl bornsou using D:\matching extremes\stata\data\bwa.asc if p_bwa!=., nolabel

* Broad specification, men, MA
probit tm black hisp asmatkno asautsho schpriv expsusp curr_col curr_gen gradpar occparh sibl bornsou if tm!=. & fem==0 & yrhs<85
predict p_bmm if tm!=. & fem==0 & yrhs<85
predict ind_bmm if tm!=. & fem==0 & yrhs<85, index
outfile id tm p_bmm ind_bmm weigh79 black hisp age79 yrhs yrdeg2 wage79-wage95 exp79 exp80 exp81 exp82 exp83 exp84 exp85 exp86 exp87 exp88 exp89 exp90 exp91 exp92 exp93 exp94 exp95 exps79 exps80 exps81 exps82 exps83 exps84 exps85 exps86 exps87 exps88 exps89 exps90 exps91 exps92 exps93 exps94 exps95 cexpm79-cexpm95 cexpsm79-cexpsm95 asmatkno asautsho schpriv expsusp curr_col curr_gen gradpar occparh sibl bornsou using D:\matching extremes\stata\data\bmm.asc if p_bmm!=., nolabel

* Broad specification, women, MA
probit tm black hisp asmatkno asautsho schpriv expsusp curr_col curr_gen gradpar occparh sibl bornsou if tm!=. & fem==1 & yrhs<85
predict p_bwm if tm!=. & fem==1 & yrhs<85
predict ind_bwm if tm!=. & fem==1 & yrhs<85, index
outfile id tm p_bwm ind_bwm weigh79 black hisp age79 yrhs yrdeg2 wage79-wage95 exp79 exp80 exp81 exp82 exp83 exp84 exp85 exp86 exp87 exp88 exp89 exp90 exp91 exp92 exp93 exp94 exp95 exps79 exps80 exps81 exps82 exps83 exps84 exps85 exps86 exps87 exps88 exps89 exps90 exps91 exps92 exps93 exps94 exps95 cexpm79-cexpm95 cexpsm79-cexpsm95 asmatkno asautsho schpriv expsusp curr_col curr_gen gradpar occparh sibl bornsou using D:\matching extremes\stata\data\bwm.asc if p_bwm!=., nolabel

* Narrow specification, men, BA, no bornsou because of symmetry with the other degrees
probit t black hisp asmatkno gradpar if t!=. & fem==0 & yrhs<90
predict p_nmb if t!=. & fem==0 & yrhs<90
predict ind_nmb if t!=. & fem==0 & yrhs<90, index
outfile id t p_nmb ind_nmb weigh79 black hisp age79 yrhs yrdeg2 wage79-wage95 exp79 exp80 exp81 exp82 exp83 exp84 exp85 exp86 exp87 exp88 exp89 exp90 exp91 exp92 exp93 exp94 exp95 exps79 exps80 exps81 exps82 exps83 exps84 exps85 exps86 exps87 exps88 exps89 exps90 exps91 exps92 exps93 exps94 exps95 cexpm79-cexpm95 cexpsm79-cexpsm95 asmatkno gradpar using D:\matching extremes\stata\data\nmb.asc if p_nmb!=., nolabel

* Narrow specification, women, BA
probit t black hisp asmatkno gradpar if t!=. & fem==1 & yrhs<90
predict p_nwb if t!=. & fem==1 & yrhs<90
predict ind_nwb if t!=. & fem==1 & yrhs<90, index
outfile id t p_nwb ind_nwb weigh79 black hisp age79 yrhs yrdeg2 wage79-wage95 exp79 exp80 exp81 exp82 exp83 exp84 exp85 exp86 exp87 exp88 exp89 exp90 exp91 exp92 exp93 exp94 exp95 exps79 exps80 exps81 exps82 exps83 exps84 exps85 exps86 exps87 exps88 exps89 exps90 exps91 exps92 exps93 exps94 exps95 cexpm79-cexpm95 cexpsm79-cexpsm95 asmatkno gradpar using D:\matching extremes\stata\data\nwb.asc if p_nwb!=., nolabel

* Narrow specification, men, AA: no bornsou because it is irrelevant!
probit ta black hisp asmatkno gradpar if ta!=. & fem==0 & yrhs<93
predict p_nma if ta!=. & fem==0 & yrhs<93
predict ind_nma if ta!=. & fem==0 & yrhs<93, index
outfile id ta p_nma ind_nma weigh79 black hisp age79 yrhs yrdeg2 wage79-wage95 exp79 exp80 exp81 exp82 exp83 exp84 exp85 exp86 exp87 exp88 exp89 exp90 exp91 exp92 exp93 exp94 exp95 exps79 exps80 exps81 exps82 exps83 exps84 exps85 exps86 exps87 exps88 exps89 exps90 exps91 exps92 exps93 exps94 exps95 cexpm79-cexpm95 cexpsm79-cexpsm95 asmatkno gradpar using D:\matching extremes\stata\data\nma.asc if p_nma!=., nolabel

* Narrow specification, women, AA
probit ta black hisp asmatkno gradpar if ta!=. & fem==1 & yrhs<93
predict p_nwa if ta!=. & fem==1 & yrhs<93
predict ind_nwa if ta!=. & fem==1 & yrhs<93, index
outfile id ta p_nwa ind_nwa weigh79 black hisp age79 yrhs yrdeg2 wage79-wage95 exp79 exp80 exp81 exp82 exp83 exp84 exp85 exp86 exp87 exp88 exp89 exp90 exp91 exp92 exp93 exp94 exp95 exps79 exps80 exps81 exps82 exps83 exps84 exps85 exps86 exps87 exps88 exps89 exps90 exps91 exps92 exps93 exps94 exps95 cexpm79-cexpm95 cexpsm79-cexpsm95 asmatkno gradpar using D:\matching extremes\stata\data\nwa.asc if p_nwa!=., nolabel

* Narrow specification, men, MA
probit tm black hisp asmatkno gradpar if tm!=. & fem==0 & yrhs<85
predict p_nmm if tm!=. & fem==0 & yrhs<85
predict ind_nmm if tm!=. & fem==0 & yrhs<85, index
outfile id tm p_nmm ind_nmm weigh79 black hisp age79 yrhs yrdeg2 wage79-wage95 exp79 exp80 exp81 exp82 exp83 exp84 exp85 exp86 exp87 exp88 exp89 exp90 exp91 exp92 exp93 exp94 exp95 exps79 exps80 exps81 exps82 exps83 exps84 exps85 exps86 exps87 exps88 exps89 exps90 exps91 exps92 exps93 exps94 exps95 cexpm79-cexpm95 cexpsm79-cexpsm95 asmatkno gradpar using D:\matching extremes\stata\data\nmm.asc if p_nmm!=., nolabel

* Narrow specification, women, MA
probit tm black hisp asmatkno gradpar if tm!=. & fem==1 & yrhs<85
predict p_nwm if tm!=. & fem==1 & yrhs<85
predict ind_nwm if tm!=. & fem==1 & yrhs<85, index
outfile id tm p_nwm ind_nwm weigh79 black hisp age79 yrhs yrdeg2 wage79-wage95 exp79 exp80 exp81 exp82 exp83 exp84 exp85 exp86 exp87 exp88 exp89 exp90 exp91 exp92 exp93 exp94 exp95 exps79 exps80 exps81 exps82 exps83 exps84 exps85 exps86 exps87 exps88 exps89 exps90 exps91 exps92 exps93 exps94 exps95 cexpm79-cexpm95 cexpsm79-cexpsm95 asmatkno gradpar using D:\matching extremes\stata\data\nwm.asc if p_nwm!=., nolabel
