% SICEGLS.M               
% Lutz Kilian
% University of Michigan
% January 1997

function [sicorder]=sicegls(y)

%kmax=8;
kmax=4;

sic=zeros(1,kmax+1);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
z=y(:,1)-y(:,2);
[t,q]=size(y);

% Drop one observation to account for first-differencing
t=t-1;

% Define lagged z and first-differenced y
z_1  =z(1:t,:);
ydiff=y(2:t+1,:)-y(1:t,:);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Define the Y and X for EGLS

for jj=0:kmax
	
	if jj==0
		X=[ones(t-kmax,1) z_1(kmax+1:t,:)]';
	elseif jj==1
		X=[ones(t-kmax,1) z_1(kmax+1:t,:) ydiff(kmax:t-1,:)]';
	elseif jj==2
		X=[ones(t-kmax,1) z_1(kmax+1:t,:) ydiff(kmax:t-1,:) ydiff(kmax-1:t-2,:)]';
	elseif jj==3
		X=[ones(t-kmax,1) z_1(kmax+1:t,:) ydiff(kmax:t-1,:) ydiff(kmax-1:t-2,:) ydiff(kmax-2:t-3,:)]';
	elseif jj==4
		X=[ones(t-kmax,1) z_1(kmax+1:t,:) ydiff(kmax:t-1,:) ydiff(kmax-1:t-2,:) ydiff(kmax-2:t-3,:) ydiff(kmax-3:t-4,:)]';
	elseif jj==5
		X=[ones(t-kmax,1) z_1(kmax+1:t,:) ydiff(kmax:t-1,:) ydiff(kmax-1:t-2,:) ydiff(kmax-2:t-3,:) ydiff(kmax-3:t-4,:) ydiff(kmax-4:t-5,:)]';
	elseif jj==6
		X=[ones(t-kmax,1) z_1(kmax+1:t,:) ydiff(kmax:t-1,:) ydiff(kmax-1:t-2,:) ydiff(kmax-2:t-3,:) ydiff(kmax-3:t-4,:) ydiff(kmax-4:t-5,:) ydiff(kmax-5:t-6,:)]';
	elseif jj==7
		X=[ones(t-kmax,1) z_1(kmax+1:t,:) ydiff(kmax:t-1,:) ydiff(kmax-1:t-2,:) ydiff(kmax-2:t-3,:) ydiff(kmax-3:t-4,:) ydiff(kmax-4:t-5,:) ydiff(kmax-5:t-6,:) ydiff(kmax-6:t-7,:)]';
	elseif jj==8
		X=[ones(t-kmax,1) z_1(kmax+1:t,:) ydiff(kmax:t-1,:) ydiff(kmax-1:t-2,:) ydiff(kmax-2:t-3,:) ydiff(kmax-3:t-4,:) ydiff(kmax-4:t-5,:) ydiff(kmax-5:t-6,:) ydiff(kmax-6:t-7,:) ydiff(kmax-7:t-8,:)]';
	else
		disp('Error: k must not exceed 8.')
		break
	end;

	% Make endogenous variable conformable with X matrix
	Y = ydiff(kmax+1:t,:)';   

	[B,OMEGA,np]=egls(Y,X,jj);
	
        % Calculating value of sic(jj)

	fterm=log(det(OMEGA));          	 % Log likelihood (dropping constants)
   %sic(jj+1)=fterm+np*log(t-kmax)/(t-kmax); % SIC values 
 	sic(jj+1)=fterm+np*2/(t-kmax);	 	  % AIC values

end;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Minimizing the sic criterion to obtain the optimal lag order
[sicmin,sicorder]=min(sic);
sicorder=sicorder-1;
