% File: S0.G
% Procedure to compute 2*pi*F(0), where F(0) is the estimated spectral
%  density of a (Txk) MATRIX of data at frequency zero, i.e., 2*pi*F(0) =
%  asy variance-covariance matrix.
%  Note: Bartlett window is used, i.e., this estimator corresponds to
%        the Newey-West (1987) estimator of the long-run variance.
%
%        INPUT:  Z(Txk)   matrix of data.
%                m(1x1)   bandwidth parameter (from ANDREWS.g if Andrews
%                         (1991) plug-in bandwidth choice is to be
%                         implemented).
%
%        OUTPUT: S0(kxk)  asyvar(Z).
%
%
%  Note that in the bivariate regression context each row of Z, i.e.,
%  Z(t), typically contains (u(t)*1, u(t)*x(t)), where u is the estimated
%  error term and x(t) is the RHS variable.
%  Reference: Hamilton (1994), pag. 281.


function s=s0(z,m)
     
       dz    = detrend(z,0)'; 
       t     = size(z,1);
       g0    = dz*dz'/t;
       s0    = 0;
       j=1; 
       while j <= m;
             gj = dz(:,1:t-j)*dz(:,1+j:t)'/t;
                    s0 = s0 + ( 1 - (j/(m+1)) ) *  ( gj + gj');
       j=j+1;
       end;
       s = g0 + s0;

