% AICAR.M

% Lutz Kilian
% University of Pennsylvania
% March 1994

function [faorder]=aicar(fay,maxlag)

[t,q]=size(fay);
con=ones(t-maxlag,1);

faic=zeros(1,maxlag+1);

% Loop that calculates the faic and fsic for every lag jj=0,...,maxlag

for jj = 0:maxlag

	% Setting the LHS variable
	yy = fay(maxlag+1:t,:);   

	% Setting the RHS predetermined variables for each jj

	if jj == 0
	    xx = [con];
	elseif jj==1
	    xx = [con fay(maxlag:t-1,:)];     
	elseif jj == 2
	    xx = [con fay(maxlag:t-1,:) fay(maxlag-1:t-2,:)];
	elseif jj == 3
	    xx = [con fay(maxlag:t-1,:) fay(maxlag-1:t-2,:) ...
		  fay(maxlag-2:t-3,:)];
	elseif jj == 4
	    xx = [con fay(maxlag:t-1,:) fay(maxlag-1:t-2,:) ...
		  fay(maxlag-2:t-3,:) fay(maxlag-3:t-4,:)];
	elseif jj == 5
	    xx = [con fay(maxlag:t-1,:) fay(maxlag-1:t-2,:) ...
		  fay(maxlag-2:t-3,:) fay(maxlag-3:t-4,:) fay(maxlag-4:t-5,:)];
	elseif jj == 6
	    xx = [con fay(maxlag:t-1,:) fay(maxlag-1:t-2,:) ...
		  fay(maxlag-2:t-3,:) fay(maxlag-3:t-4,:) fay(maxlag-4:t-5,:) ...
		  fay(maxlag-5:t-6,:)];
	elseif jj == 7
	    xx = [con fay(maxlag:t-1,:) fay(maxlag-1:t-2,:) ...
		  fay(maxlag-2:t-3,:) fay(maxlag-3:t-4,:) fay(maxlag-4:t-5,:) ...
		  fay(maxlag-5:t-6,:) fay(maxlag-6:t-7,:)];
	elseif jj == 8
	    xx = [con fay(maxlag:t-1,:) fay(maxlag-1:t-2,:) ...
		  fay(maxlag-2:t-3,:) fay(maxlag-3:t-4,:) fay(maxlag-4:t-5,:) ...
		  fay(maxlag-5:t-6,:) fay(maxlag-6:t-7,:) fay(maxlag-7:t-8,:)];
	end;   

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	bhat1=(xx'*xx)\(xx'*yy(:,1));
	ephat1=yy(:,1)-xx*bhat1;            
	OMEGA(1,1)=(ephat1'*ephat1)/(t-maxlag);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Calculating faic(jj)

fterm=log(det(OMEGA));          % Log likelihood (dropping constants)

faic(jj+1)=fterm+(q^2*jj+q)*2/(t-maxlag);              % AIC value
%faic(jj+1)=fterm+(q^2*jj+q)*log(t-maxlag)/(t-maxlag); 	% SIC value

% Freeing memory
clear fterm xx OMEGA yi xi ephat1 ephat2 bhat1 bhat2;

end;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Minimizing the faic criterion to obtain the optimal lag order
[faicmin,faorder]=min(faic);
faorder=faorder-1;
%faic
