/* 
 THIS SAS PROGRAM READS MARCH 1968 CURRENT POPULATION SURVEY
 AND PULLS MICRO DATA.
*/ 
LIBNAME SCR '/otel1e/cpstemp'; 
OPTIONS LS=80; 
/* OPTIONS OBS=4000; */

FILENAME CPSMAR68 '/otel1e/cpstemp/cps68.dat';
 
DATA SCR.CPS68fm; 
 
TITLE1 'MARCH 1968 CPS DATA FOR ALL WOMEN 16-70 YEARS OF AGE';
TITLE2 'CPS DATA COPIED FROM TAPE CPS68 (KEVIN MURPHY)'; 

INFILE CPSMAR68 LRECL=216; 
 
/* LENGTH */
/* For the household record: */ 
/* For the family record: */ 
/* For the person record: */ 

serialno=0;

 *START OF LOOP;         
     
startr:;

INPUT TYPE 1 TYPEFAM 27-28 @; 
NEXTFAM: ;

IF TYPE LT 4 THEN GO TO NEXTPER;
IF TYPEFAM EQ 4 THEN DO;
   INPUT;
   GO TO NEXTPER;
END;

ELSE DO;
    *READ FAMILY RECORD;
    serialno=serialno+1;
 
    INPUT SEXHEAD 32 NUMREC 35-36 STATE 37-38
          MPRANK 39-40 MSMSA 42 NUMFAM 47-48 NUMPERS 49-50
          FAMSIZE 53-54 FUNDR18 55-56 FAM18T64 57 FAM65OVR 58
          CHLD 59-60 CHLD25 61-62 CHLD18 63-64 CHLD3 65
          CHLD1 66 CHLDPRNT 67 FINCTOT 73-78 FINCEARN 79-84
          FINCOTH 85-90 FAMSRINC 111-112 FAMINLF 113 FAMEARNR 114;


    IF TYPEFAM GT 4 THEN DO;
       FUNDR18=0;
       FAM18T64=0;
       FAM65OVR=0;
       CHLD=0;
       CHLD25=0;
       CHLD18=0;
       CHLD3=0;
       CHLD1=0;
    END;
    FNUMPER=MAX(NUMREC,FAMSIZE);

    DO IP=1 TO FNUMPER;
      NEXTPER:;
      INPUT TYPE 1 TYPEFAM 27-28 AGE 29-30 SEX 32 @;
      IF TYPE = 4 THEN DO;
         GO TO NEXTFAM;
      END;
      ELSE IF 15 < AGE < 71 AND SEX > 1 THEN DO; 
      INPUT  POPSTAT 1 TYPEFAM 27-28 AGE 29-30
             SEX 32 RACE 33 LINENUM 34-35 RELHEAD 38 FMKEY 39
             SUBKEY 40 RELHHR1 41-42 RELFAMR 43-44 MARSTAT 45
             HIGHGRAD 57-58 GRADECOM 59 INCTOT 61-66 INCWGSAL 67-72
             INCSE 73-78 INCFARM 79-84 INCSSRR 85-90 INCDIV 91-96
             INCPUAS 97-102 INCUC 103-108 INCAL 109-114 RPSINC1 129-130
             WKWRKLY 131 FLPTLY 132 IND_LY 133-135 OCC_LY 136-138
             CLASS_LY 139 WKNOTWRK 145 REASNWLY 149 ACTLW 151
             ESR 152 HRWRKLW 153-154 UHWOV35 155 LOOKPT 165
             LWRK2WKS 168 INDUSTRY 169-171 OCCUP 172-174 CLASS 175
             HRWRK 181-182 WEIGHT 205-216;

      IF TYPEFAM > 4 THEN DO;
         IF AGE < 18 THEN FUNDR18=1;
         IF AGE GE 18 AND AGE LE 64 THEN FAM18T64=1;
         IF AGE GE 65 THEN FAM65OVR=1;
      END;
      END;
      ELSE DO; 
      INPUT; 
      GO TO NEXTPER; 
      END; 
 
           WEIGHT=WEIGHT/100;
 
      DROP TYPE IP; 
 
      OUTPUT; 
 
      END;  /* END OF PERSON LOOP*/ 
    END;  /* END OF FAMILY LOOP*/ 
go to startr;
 
PROC CONTENTS DATA = SCR.CPS68fm; 
PROC FREQ DATA = SCR.CPS68fm; TABLES RACE; 
PROC FREQ DATA = SCR.CPS68fm; TABLES AGE;
PROC FREQ DATA = SCR.CPS68fm; TABLES WKWRKLY;
PROC MEANS DATA = SCR.CPS68fm; 
/* 
